package sellwin.server;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class is the RMI server that offers up the
 * sellwin business objects to GUI clients.
 */
public class SellwinRMIServer {
	public static void main(String[] args) {
		System.out.println("SellwinRMIServer Starting...");
		System.setSecurityManager(new RMISecurityManager());
		try {
			String rmiHost = Prefs.getServerHost();
			String rmiServiceName = "RMIBizServices";
			String rmiURL = "//" + rmiHost + "/" + rmiServiceName;
			System.out.println("connecting to RMI service at :" + rmiURL);
			RMIBizServices impl = new RMIBizServices(rmiURL);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("SellwinRMIServer Ending...");
	}
}
