package sellwin.server;

import javax.ejb.*;
import java.util.*;
import java.rmi.*;

import sellwin.domain.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * the methods of this interface are the methods that
 * a client (Main.java) has access to over a network.
 * 
 * This interface is implemented by code which gets 
 * generated by the EJB container.  The generated code
 * delegates to the SellwinSessionBean.java class that
 * we have written.
 */
public interface SellwinSession extends EJBObject {


	/**
	 * get US tax table 
	 * @param lastSyncDate a user's last sync date used to
	 * limit the query, if null, no limiting
	 * @return the ArrayList of StateTax objects
	 */
	 public ArrayList getStateTax(java.util.Date lastSyncDate)
	 	throws RemoteException, AngError;

	/**
	 * get an index of Opportunities for a given user
	 * @param u the SalesPerson we are searching for
	 * @return the ArrayList of OppIndex objects that were found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getOpportunityIndex(SalesPerson u)
		throws RemoteException, AngError;

	/**
	 * get the list of Products that are offered 
	 * @return the ArrayList of Products found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getProductMatrix()
		throws RemoteException, AngError;

	/**
	 * get the list of Product Groups
	 * @return the ArrayList of product groups that were found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getProductGroups()
		throws RemoteException, AngError;

	/**
	 * get the list of product lines 
	 * @param group search using this passed product group as key
	 * @return the ArrayList of product lines that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getProductLines(String group)
		throws RemoteException, AngError;

	/**
	 * get the products for a product line and group
	 * @param group the product group to search in
	 * @param line the product line to search in
	 * @return the ArrayList of products found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getProductsForLine(String group, String line)
		throws RemoteException, AngError;

	/**
	 * get a product 
	 * @param group product group to search in
	 * @param line product line to search in
	 * @param name product name to search for
	 * @return the Product that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public Product getProduct(String group, String line, String name)
		throws RemoteException, AngError;

	/**
	 * add a forecast
	 * @param opportunityPK the containing Opportunity primary key
	 * @param a the Forecast we are adding
	 * @return the primary key of the new Forecast
	 * @exception AngError thrown when an app error occurs
	 */
	public long addForecast(long opportunityPK, Forecast a)
		throws RemoteException, AngError;

	/**
	 * update a Forecast 
	 * @param oppPK the containing Opportunity primary key
	 * @param a the Forecast we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateForecast(long oppPK, Forecast a)
		throws RemoteException, AngError;

	/**
	 * delete a Forecast 
	 * @param opportunityPK the containing Opportunity primary key
	 * @param forecastPK the Forecast primary key we delete with
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteForecast(long opportunityPK, long forecastPK)
		throws RemoteException, AngError;

	/**
	 * add an Order 
	 * @param oppPK the containing Opportunity primary key
	 * @param o the Order we are adding
	 * @return the primary key of the new Order
	 * @exception AngError thrown when an app error occurs
	 */
	public long addOrder(long oppPK, Order o)
		throws RemoteException, AngError;

	/**
	 * update an Order
	 * @param oppPK the containing Opportunity primary key
	 * @param o the Order we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateOrder(long oppPK, Order o)
		throws RemoteException, AngError;

	/**
	 * add a Quote 
	 * @param oppPK the containing Opportunity primary key
	 * @param q the Quote being added
	 * @return the primary key of the new Quote
	 * @exception AngError thrown when an app error occurs
	 */
	public long addQuote(long oppPK, Quote q)
		throws RemoteException, AngError;

	/**
	 * update a Quote
	 * @param oppPK the containing Opportunity primary key
	 * @param q the Quote being updated
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateQuote(long oppPK, Quote q)
		throws RemoteException, AngError;

	/**
	 * 
	 * @param name description
	 * @return description
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteQuote(long opportuntityPK, long quotePK)
		throws RemoteException, AngError;

	/**
	 * add a QuoteLine 
	 * @param oppPK the containing Opportunity primary key
	 * @param quotePK the containing Quote primary key
	 * @param a the QuoteLine being added
	 * @return the primary key of the newly added QuoteLine
	 * @exception AngError thrown when an app error occurs
	 */
	public long addQuoteLine(long oppPK, long quotePK, QuoteLine a) 
		throws RemoteException, AngError;

	/**
	 * 
	 * @param name description
	 * @return description
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteQuoteLine(long opportuntityPK, long quotePK, long linePK)
		throws RemoteException, AngError;

	/**
	 * get the Alarms for a user 
	 * @param salesPersonPK the primary key of the user to search for
	 * @return the ArrayList of Alarms found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getAlarms(long salesPersonPK)
		throws RemoteException, AngError;
		
	/**
	 * add an Activity
	 * @param opportunityPK the containing Opportunity primary key
	 * @param a the Activity we are adding
	 * @return the newly added Activity primary key
	 * @exception AngError thrown when an app error occurs
	 */
	public long addActivity(long opportunityPK, Activity a)
		throws RemoteException, AngError;

	/**
	 * update an Actvitity 
	 * @param opportunityPK the containing Opportunity primary key
	 * @param a the Activity being updated
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateActivity(long opportunityPK, Activity a)
		throws RemoteException, AngError;

	/**
	 * delete an Activity 
	 * @param opportunityPK the containing Opportunity primary key
	 * @param activityPK the Activity primary key we delete with
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteActivity(long opportunityPK, long activityPK)
		throws RemoteException, AngError;


	/**
	 * get all the user roles 
	 * @param lastSyncDate the last user sync date we used to
	 * limit the query
	 * @return the ArrayList of found user roles
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getAllUserRoles(java.util.Date lastSyncDate) 
		throws RemoteException, AngError;

	/**
	 * add a user role
	 * @param role the UserRole we are adding to the system
	 * @exception AngError thrown when an app error occurs
	 */
	public void addUserRole(UserRole role)
		throws RemoteException, AngError;

	/**
	 * delete a user role 
	 * @param pk the pk of the user role we are deleting
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteUserRole(long pk) 
		throws RemoteException, AngError;

	/**
	 * udpate a user role 
	 * @param role the UserRole we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateUserRole(UserRole role)
		throws RemoteException, AngError;
	
	/**
	 * get a user role
	 * @param name the name of the user role we search for
	 * @return the UserRole that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public UserRole getUserRole(String name)
		throws RemoteException, AngError;

	/**
	 * logon to SellWin
	 * @param id the user ID to try
	 * @param psw the password to try
	 * @return a Login object if successful
	 * @exception AngError thrown when an app error occurs
	 */
	public Login logon(String id, String psw) 
		throws RemoteException, AngError;

	/**
	 * delete a Customer 
	 * @param name the name of the Customer we are to delete
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteCustomer(String name)
		throws RemoteException, AngError;

	/**
	 * update a Customer 
	 * @param c the Customer we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateCustomer(Customer c)
		throws RemoteException, AngError;

	/**
	 * add a Customer 
	 * @param c the Customer we are adding
	 * @return the new Customer's primary key
	 * @exception AngError thrown when an app error occurs
	 */
	public long addCustomer(Customer c)
		throws RemoteException, AngError;

	/**
	 * get a Customer 
	 * @param name the name of the Customer we are to get
	 * @return the Customer that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public Customer getCustomer(String name) 
		throws RemoteException, AngError;

	/**
	 * get all the customer names in the system
	 * @return an array of the customer names
	 * @exception AngError thrown when an app error occurs
	 */
	public Object[] getAllCustomerNames() 
		throws RemoteException, AngError;

	/**
	 * get all the customers in the system
	 * @param lastSyncDate a user's last sync date used to limit
	 * the query or null if no limit
	 * @return an ArrayList of Customers
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getCustomers(java.util.Date lastSyncDate) 
		throws RemoteException, AngError;

	/**
	 * add a Product  
	 * @param p the Product we are adding
	 * @exception AngError thrown when an app error occurs
	 */
	public void addProduct(Product p)
		throws RemoteException, AngError;
	
	/**
	 * get all Products 
	 * @param a date to compare with in the query
	 * @return an ArrayList of products that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getProducts(java.util.Date afterDate) 
		throws RemoteException, AngError;

	/**
	 * get all the Opportunity names for a user
	 * @param u the user we are searching for
	 * @return an ArrayList of opportunity names
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getOpportunityNames(SalesPerson u)
		throws RemoteException, AngError;

	/**
	 * get all the Opportunities for a user
	 * @param u the user we are searching for
	 * @param lastSyncDate a user's last sync date to limit the query with
	 * or null if no limit is to be applied
	 * @return an ArrayList of Opportunities
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getOpportunities(SalesPerson u, java.util.Date lastSyncDate)
		throws RemoteException, AngError;

	/**
	 * get an Opportunity
	 * @param pk an Opportunity primary key we are searching for
	 * @return an Opportunity
	 * @exception AngError thrown when an app error occurs
	 */
	public Opportunity getOpportunity(long pk)
		throws RemoteException, AngError;

	/**
	 * add an Opportunity 
	 * @param o the Opportunity we are adding
	 * @return the primary key of the newly added object
	 * @exception AngError thrown when an app error occurs
	 */
	public long addOpportunity(Opportunity o)
		throws RemoteException, AngError;

	/**
	 * update an Opportunity
	 * @param o the Opportunity we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateOpportunity(Opportunity o)
		throws RemoteException, AngError;

	/**
	 * delete an Opportunity 
	 * @param pk the primary key of the Opportunity to delete
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteOpportunity(long pk)
		throws RemoteException, AngError;

	/**
	 * delete a contact 
	 * @param oppPK the containing Opportunity's primary key
	 * @param contPK the Contact's primary key we delete with
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteContact(long oppPk, long contPk)
		throws RemoteException, AngError;

	/**
	 * add a contact 
	 * @param oppPK the containing Opportunity's primary key
	 * @param c the Contact we are adding
	 * @return the primary key of the new Contact
	 * @exception AngError thrown when an app error occurs
	 */
	public long addContact(long oppPk, Contact c)
		throws RemoteException, AngError;

	/**
	 * update a contact
	 * @param oppPK the containing Opportunity primary key
	 * @param c the contact we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateContact(long oppPK, Contact c)
		throws RemoteException, AngError;

	/**
	 * get a sales person 
	 * @param pk the pk to search with
	 * @return the SalesPerson that was found
	 * @exception AngError thrown when an app error occurs
	 */
	public SalesPerson getSalesPerson(long pk) 
		throws RemoteException, AngError;

	/**
	 * update a sales person
	 * @param  s the sales person we are updating
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateSalesPerson(SalesPerson s)
		throws RemoteException, AngError;

	/**
	 * delete a sales person 
	 * @param sp the sales person we are to delete
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteSalesPerson(SalesPerson sp)
		throws RemoteException, AngError;

	/**
	 * add a sales person 
	 * @param s the sales person we are adding
	 * @return the primary key of the newly added person
	 * @exception AngError thrown when an app error occurs
	 */
	public long addSalesPerson(SalesPerson s) 
		throws RemoteException, AngError;

	/**
	 * get all sales person logon IDs
	 * @return an ArrayList of user IDs
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getSalesPersonIDs() 
		throws RemoteException, AngError;

	/**
	 * get all sales person names 
	 * @return an ArrayList of sales person names
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getSalesPersonNames() 
		throws RemoteException, AngError;

	/**
	 *  get all sales persons
	 * @param a user's last sync date or null if the query is not
	 * to be limited
	 * @return an array of SalesPerson objects
	 * @exception AngError thrown when an app error occurs
	 */
	public Object[] getSalesPersons(java.util.Date lastSyncDate) 
		throws RemoteException, AngError;


	/**
	 * get the groups a user belongs to
	 * @param userPK the user primary key to search with
	 * @return an ArrayList of UserGroup objects
	 */
	public ArrayList getGroupsForUser(long userPK)
		throws RemoteException, AngError;

	/**
	 * add a user to a user group
	 * @param userPK the user primary key to add
	 * @param group the user group to add to
	 * @exception AngError thrown when an app error occurs
	 */
	public void addUserToGroup(long userPK, UserGroup group) 
		throws RemoteException, AngError;


	 //THIS NEEDS TO BE OPTIMIZED, TO ONLY RETURN NAMES, NOT THE
	 //FULL SP
	/**
	 * get all users in a group
 	 *
	 * @param groupName the group we are searching with
	 * @return an ArrayList of SalesPersons that were found in the group
	 * @exception AngError thrown when an app error occurs
	 */
	public Object[] getUsersInGroup(String groupName) 
		throws RemoteException, AngError;

	/**
	 * get a UserGroup using it's primary key
	 * @param pk user group primary key
	 * @return a UserGroup if found, else null
	 * @exception AngError thrown when an app error occurs
	 */
	public UserGroup getUserGroup(long pk)
		throws RemoteException, AngError;

	/**
	 * get all user groups 
	 * @param lastSyncDate a user's last sync date which limits the query
	 * @return an array of UserGroup
	 * @exception AngError thrown when an app error occurs
	 */
	public Object[] getUserGroups(java.util.Date lastSyncDate) 
		throws RemoteException, AngError;

	/**
	 * add a user group 
	 * @param g the user group to add
	 * @exception AngError thrown when an app error occurs
	 */
	public void addUserGroup(UserGroup g) 
		throws RemoteException, AngError;

	/**
	 * delete a user group 
	 * @param groupName the user group name we are to delete
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteUserGroup(String groupName) 
		throws RemoteException, AngError;

	/**
	 * delete a user in a group 
	 * @param g the user group to search in
	 * @param userPK the user primary key to delete 
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteUserInGroup(UserGroup g, long userPK)
		throws RemoteException, AngError;

	/**
	 * update a lead 
	 * @param campaignPK the containing Campaign primary key
	 * @param l the Lead we are to update
	 * @exception AngError thrown when an app error occurs
	 */
	public void updateLead(long campaignPK, Lead l)
		throws RemoteException, AngError;

	/**
	 * get all campaigns 
	 * @param lastSyncDate a user's last sync date which limits the
	 * query or null if no limit
	 * @return an ArrayList of campaigns
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getCampaigns(java.util.Date lastSyncDate)
		throws RemoteException, AngError;

	/**
	 * get all leads for a campaign
	 * @param campaignPK the campaign primary key to search with
	 * @return an ArrayList of campaign leads that were found
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getCampaignLeads(long campaignPK)
		throws RemoteException, AngError;

	public ArrayList getCampaignLeads(java.util.Date dt)
		throws RemoteException, AngError;

	public ArrayList getGroupMembers(java.util.Date dt)
		throws RemoteException, AngError;
	/**
	 * delete a CustomerInventory 
	 * @param ci the CustomerInventory we are to delete
	 * @exception AngError thrown when an app error occurs
	 */
	public void deleteCustomerInventory(CustomerInventory ci)
		throws RemoteException, AngError;

	/**
	 * add a CustomerInventory 
	 * @param ci the CustomerInventory we are adding
	 * @return the new CustomerInventory's primary key
	 * @exception AngError thrown when an app error occurs
	 */
	public long addCustomerInventory(CustomerInventory ci)
		throws RemoteException, AngError;

	/**
	 * get CustomerInventory  for a given customer
	 * @param custPK the Customer's PK we are searching with
	 * @return the list of CustomerInventory 
	 * @exception AngError thrown when an app error occurs
	 */
	public ArrayList getCustomerInventory(long custPK)
		throws RemoteException, AngError;

	/**
	 * upload the deletes from local to remote 
	 * @param deletes an ArrayList of delete info
	 */
	 public void uploadDeletes(ArrayList deletes)
	 	throws RemoteException, AngError;

}
