package sellwin.server;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * this interface is the home interface for the SellwinSession
 * stateful session bean (EJB).  This interface is implemented
 * by the EJB container (e.g. Weblogic) which will generate a 
 * Java class that handles the 'home' lookup for clients of
 * the SellwinSession session bean.
 */
public interface SellwinSessionHome extends EJBHome {

	/**
	 * this method corresponds to the ejbCreate() method in the 
	 * bean "SellwinSession.java".
	 *
	 * @return SellwinSession
	 * @exception RemoteException if there is a communications failure
	 * @exception CreateException if there is an error creating the bean
	 */
	public SellwinSession create() throws CreateException, RemoteException;
}
