/*
 * JS taint check
 */

#ifndef jsinfoflow_h___
#define jsinfoflow_h___

#include "jsprvtd.h"
#include "jspubtd.h"
#include "jsopcode.h"

JS_BEGIN_EXTERN_C

/*
 * Stack macros and functions.  These all use a local variable, jsval *tsp, to
 * point to the next free stack slot.  SAVE_TSP must be called before any call
 * to a function that may invoke the interpreter.  RESTORE_TSP must be called
 * only after return from js_Invoke, because only js_Invoke changes fp->tsp.
 */
#define PUSHT(v)         (*tsp++ = (v))
#define POPT()           (*--tsp)

/*
 * Push the generating bytecode's pc onto the parallel pc stack that runs
 * depth slots below the operands.
 *
 * NB: PUSH_TOPND uses tsp, depth, and pc from its lexical environment.  See
 * js_Interpret for these local variables' declarations and uses.
 */
#define PUSH_TOPND(v)    (PUSHT((uint32*)((uint32)v|(uint32)fp->current_depth_taint|(uint32)union_taint)))
#define STORE_TOPND(n,v) (tsp[n] = (v))
#define POP_TOPND()      POPT()
#define FETCH_TOPND(n)   (tsp[n])

struct fieldTaint {
	void 				*id;
	uint32 				*taint;
	struct fieldTaint 	*next;
};

/*
#define TAINT_ON_OBJECT(obj, trval)				\
		FIND_TAINT_IN_TABLE(obj->table, trval)	\
		
#define FIND_TAINT_IN_TABLE(table, trval)										\		
		while(table->next!=NULL){												\
			if((uint32)table->taint > 0)										\
				trval = 1;														\
			else																\
				FIND_TAINT_IN_TABLE((struct fieldTaint*)table->taint, trval)	\
		}																		\
*/

struct nested_taint {

	/* taint flag for this scope. */
	uint32 *taint;

	/* the opcode that created the scope */
	JSOp opcode;

	/* pc-marks to set boundries of the scope */
	jsbytecode *from;
	jsbytecode *to;

	struct nested_taint	*next;
	struct nested_taint	*prev;
};
				
#define TAINT_HIGH	0x1
#define	TAINT_LOW	0x0

#define IS_TAINTED(v)			\
		(v > TAINT_LOW)					
			
#define INIT_DEPTH_TAINT(framefp, value)													\
		framefp.depth_taint = (struct nested_taint*)malloc(sizeof(struct nested_taint));	\
		/*printf("\nINIT : framefp->depth_taint = %x",framefp.depth_taint);*/				\
		framefp.depth_taint->taint = (uint32*)((uint32)framefp.current_depth_taint | (uint32)value);		\
		/*printf("\nframefp->depth_taint->taint = %d",framefp.depth_taint->taint);*/		\
		framefp.depth_taint->from = framefp.script->code;									\
		framefp.depth_taint->to = framefp.script->code + framefp.script->length;			\
		framefp.depth_taint->prev = NULL;													\
		framefp.depth_taint->next = NULL;																		
		
#define CREATE_NEW_DEPTH_TAINT(framefp, value, op, start, end)										\
		if(value > framefp->current_depth_taint){													\
			/*printf("\nframefp->depth_taint = %x",framefp->depth_taint);*/							\
			framefp->depth_taint->next = (struct nested_taint*)malloc(sizeof(struct nested_taint));	\
			/*printf("\nframefp->depth_taint->next = %x",framefp->depth_taint->next);*/				\
			/*printf("\nframefp->depth_taint->prev = %x",framefp->depth_taint->prev);*/				\
			framefp->depth_taint->next->prev = framefp->depth_taint;								\
			framefp->depth_taint->next->next = NULL;												\
			framefp->depth_taint->next->taint = (uint32*)((uint32)framefp->current_depth_taint | (uint32)value);	\
			framefp->depth_taint->next->opcode = op;												\
			framefp->depth_taint->next->from = start;												\
			framefp->depth_taint->next->to = end;													\
			framefp->current_depth_taint = framefp->depth_taint->next->taint;						\
			/*printf("\nCurrent nested depth taint = %d", framefp->depth_taint->next->taint);*/		\
			printf("\nCurrent scope taint = %d", framefp->current_depth_taint);						\
			framefp->depth_taint = framefp->depth_taint->next;										\
		}																							
		 		
#define FREE_NESTED_DEPTH_TAINT(fp, pc)														\
	if(fp->depth_taint != NULL){															\
		/*printf("\nfp->depth_taint = %x",fp->depth_taint);*/								\
		/*printf("\nfp->depth_taint->taint = %d",fp->depth_taint->taint);*/					\
	 	if(pc == fp->depth_taint->to){														\
	 		/*printf("\nfp->depth_taint->prev = %x",fp->depth_taint->prev);*/				\
	 		/*printf("\nfp->depth_taint->prev->taint = %d",fp->depth_taint->prev->taint);*/	\
    		fp->depth_taint = fp->depth_taint->prev;										\
    		/*printf("\nfp->depth_taint = %x",fp->depth_taint);*/							\
    		/*printf("\nfp->depth_taint->taint = %d",fp->depth_taint->taint);*/				\
    		free(fp->depth_taint->next);													\
    		fp->depth_taint->next = NULL;													\
    		fp->current_depth_taint = fp->depth_taint->taint;								\
    		printf("\nLeaving : fp->current_depth_taint = %d\n",fp->current_depth_taint);	\
	 	}																					\
    }

JS_END_EXTERN_C

#endif
