#!/usr/bin/python
import sys
from statlib import stats

FREQ = 1330000000

if len(sys.argv) < 1:
    print "GIVE ME ONE FILE AS ARG"
    sys.exit(1)

lines   = [x.strip().split() for x in open(sys.argv[1], 'r').readlines()]

diff = []
wrong_count = 0;

for i in range(len(lines) - 1):
   if lines[i][0] > lines[i][1]:
       diff.append(int(lines[i][2]))
   else:
       wrong_count = wrong_count + 1;

mean = stats.mean(diff)
stdev = stats.stdev(diff)

print '%f %f' % (mean, stdev)
print '%f %f' % (mean/FREQ, stdev/FREQ)
print '%d' % (wrong_count)
