#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/mman.h>
#include <gcrypt.h>
#include <sqlite3.h>
#include <time.h>
#include <xenctrl.h>
#include <pthread.h>

#define MAX_PAGE_NUM 4745

#define rdtscll(val) \
     __asm__ __volatile__("rdtsc" : "=A" (val))

/* macros for bitmap */
#define BITS_PER_LONG (sizeof(unsigned long) * 8)
#define BITS_TO_LONGS(bits) (((bits)+BITS_PER_LONG-1)/BITS_PER_LONG)
#define BITMAP_SIZE   (BITS_TO_LONGS(p2m_size) * sizeof(unsigned long))

#define BITMAP_ENTRY(_nr,_bmap) \
   ((volatile unsigned long *)(_bmap))[(_nr)/BITS_PER_LONG]

#define BITMAP_SHIFT(_nr) ((_nr) % BITS_PER_LONG)

#define PAGE_SHIFT 12

#define ROUNDUP(_x,_w) (((unsigned long)(_x)+(1UL<<(_w))-1) & ~((1UL<<(_w))-1))


unsigned long *bitmap;
unsigned char *build_memory_map(uint32_t domain);
xen_pfn_t *get_p2m_table(int xc_handle, uint32_t dom);
xen_pfn_t *get_m2p_table(int xc_handle, uint32_t dom);

int xc_handle, dom;
uint64_t patagonix_info_frame;
uint64_t patagonix_time_frame;
static xen_pfn_t *live_p2m;
static xen_pfn_t *live_m2p;
unsigned long p2m_size;	
unsigned char *memory_map;
int round_num;
int socket_talk;


static inline int test_bit (int nr, volatile void * addr)
{
    return (BITMAP_ENTRY(nr, addr) >> BITMAP_SHIFT(nr)) & 1;
}

void *xg_memalign(size_t alignment, size_t size)
{
#if defined(_POSIX_C_SOURCE) && !defined(__sun__)
    int ret;
    void *ptr;
    ret = posix_memalign(&ptr, alignment, size);
    if (ret != 0)
        return NULL;
    return ptr;
#elif defined(__NetBSD__) || defined(__OpenBSD__)
    return valloc(size);
#else
    return memalign(alignment, size);
#endif
}

void my_handler(int s) {
	printf("caught signal %d\n",s);
	exit(1);
}

void send_pages(int dirty){
			char request[10];
			char response[3];			
		
			memset(request,0,0);
			memset(response,0,0);
			int i;			
			int dirty_count = 0;
			for(i=0;i < p2m_size; i++)
			{
				if(test_bit(i,bitmap) == 1 && (i >= 0x237 && i < 0x457))
				{
					dirty_count++;
				}
			}

			sprintf(request,"%d",dirty_count);

			int result;
			result = correct_write(socket_talk, request, 10);
			if(result == 10){
				result = correct_read(socket_talk,response,3);
			}
				
			printf("requested %d pages response: %s\n",dirty_count,response);		

			char *buffer = malloc(dirty_count*0x1000);
			memset(buffer,0,dirty_count*0x1000);
	
			int count = 0;
			for(i=0;i < p2m_size; i++)
			{
				if(test_bit(i,bitmap) == 1 && (i >= 0x237 && i < 0x457))
				{
					unsigned long pfn = i;
					memcpy(buffer+count*0x1000,memory_map+pfn*0x1000, 0x1000);	
					count++;
				}
			}
					
			// send pages;
		
			result = correct_write(socket_talk, buffer, dirty_count*0x1000);
			if(result == 10){
				result = correct_read(socket_talk,response,3);
			}
			printf("done\n");		
}


int main(int argc, char **argv) 
{

	int frc,errno,rc;
	xc_shadow_op_stats_t stats;

	signal(SIGINT,my_handler);

	dom = atoi(argv[1]);

	if((socket_talk = sconnect(argv[2],argv[3])) < 0) {
		printf("sconnect error\n");
		exit(1);
	}

	live_p2m = NULL;
	live_m2p = NULL;

	round_num = 0;

	xc_handle = xc_interface_open();

	if(xc_handle == -1) {
		fprintf(stderr, "Unable to get handle to hypervisor\n");
		exit(-1);
	}
	
	memory_map = (unsigned char *)build_memory_map(dom);
	live_p2m = (xen_pfn_t *) get_p2m_table(xc_handle, dom);
	live_m2p = (xen_pfn_t *) get_m2p_table(xc_handle, dom);

	p2m_size = xc_memory_op(xc_handle, XENMEM_maximum_gpfn, &dom) + 1;


	/* Live suspend. Enable log-dirty mode. */
	if ( xc_shadow_control(xc_handle, dom,
							XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
							NULL, 0, NULL, 0, NULL) < 0 )
	{
		/* log-dirty already enabled? There's no test op,
		 * so attempt to disable then reenable it */
		frc = xc_shadow_control(xc_handle, dom, 
					XEN_DOMCTL_SHADOW_OP_OFF,
					NULL, 0, NULL, 0, NULL);
		if ( frc >= 0 )
		{
			frc = xc_shadow_control(xc_handle, dom,
									XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
									NULL, 0, NULL, 0, NULL);
		}

		if ( frc < 0 )
		{
			fprintf(stderr,"Couldn't enable shadow mode (rc %d) (errno %d)", frc, errno );
			exit(-1);
		}
	}

	bitmap = (unsigned long *)xg_memalign(PAGE_SIZE, ROUNDUP(BITMAP_SIZE, PAGE_SHIFT));

        if ( !bitmap )
        {
              fprintf(stderr,"Couldn't allocate bitmap array");
              exit(-1);
        }

        memset(bitmap, 0xff, BITMAP_SIZE);

	while(1)
	{
	           if ( xc_shadow_control(xc_handle, dom,
                                   XEN_DOMCTL_SHADOW_OP_CLEAN, bitmap,
                                   p2m_size, NULL, 0, &stats) != p2m_size )
                   {
                        fprintf(stderr,"Error flushing shadow PT");
                         exit(-1);
                    }

                    fprintf(stderr,"stats: dirty: %d\n",stats.dirty_count);
		
		send_pages(stats.dirty_count);

	
		printf("done round %d\n",round_num);	
		round_num++;

		sleep(30);
		
	}	
}

