/**
 * server.c, copyright 2001 Steve Gribble
 *
 * The server is a single-threaded program.  First, it opens
 * up a "listening socket" so that clients can connect to
 * it.  Then, it enters a tight loop; in each iteration, it
 * accepts a new connection from the client, reads a request,
 * computes for a while, sends a response, then closes the
 * connection.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <pthread.h>
#include <sys/time.h>
#include <time.h>

#include "SocketLibrary/socklib.h"
#include "common.h"

extern int errno;

int   setup_listen(char *socketNumber);
char *read_request(int fd, int size);
void  send_response(int fd, char *response, int response_length);
int quit=0;

/**
 * This program should be invoked as "./server <socketnumber>", for
 * example, "./server 4342".
 */

int main(int argc, char **argv)
{
    int  socket_listen;
int total_pages;
  printf("START\n");
  if (argc != 2)
  {
    fprintf(stderr, "(SERVER): Invoke as  './server socknum'\n");
    fprintf(stderr, "(SERVER): for example, './server 4434'\n");
    exit(-1);
  }

  /* 
   * Set up the 'listening socket'.  This establishes a network
   * IP_address:port_number that other programs can connect with.
   */
  	socket_listen = setup_listen(argv[1]);
  
	int  socket_talk;
	total_pages = 0;
	
  	socket_talk = saccept(socket_listen);  // step 1

	if (socket_talk < 0) {
		fprintf(stderr, "An error occured in the server; a connection\n");
		fprintf(stderr, "failed because of ");
		perror("");
		exit(1);
	}
	
	int num = 0;

	while(1) {
		char *request = NULL;
		char *response = NULL;
		int num_pages=0;

 		request = read_request(socket_talk,10);  // step 2
  		if (request != NULL) {
    			int response_length=3;

    			response = "ok\0";  // step 3
    			if (response != NULL) {
      				send_response(socket_talk, response, response_length);  // step 4
    			}
  		}	

		printf("recieved request %d: %s pages\n",num,request);

		num_pages = atoi(request);
		request = read_request(socket_talk,num_pages*0x1000);
		if (request != NULL) {	
    			int response_length=3;
		//	sleep(1);
    			
			response = "ok\0";
			if (response != NULL) {
      				send_response(socket_talk, response, response_length);  // step 4
    			}
		}	
		total_pages = total_pages+num_pages;
		printf("done %d - total_pages: %d\n",num,total_pages);	
		num++;

	}
}

/**
 * This function accepts a string of the form "5654", and opens up
 * a listening socket on the port associated with that string.  In
 * case of error, this function simply bonks out.
 */

int setup_listen(char *socketNumber) {
  int socket_listen;

  if ((socket_listen = slisten(socketNumber)) < 0) {
    perror("(SERVER): slisten");
    exit(1);
  }

  return socket_listen;
}

/**
 * This function reads a request off of the given socket.
 * This function is thread-safe.
 */

char *read_request(int fd, int size) {
  char *request = (char *) malloc(size*sizeof(char));
  int   ret;

  if (request == NULL) {
    fprintf(stderr, "(SERVER): out of memory!\n");
    exit(-1);
  }

printf("before correct read\n");

  ret = correct_read(fd, request, size);
  if (ret != size) {
    free(request);
    request = NULL;
  }
  return request;
}
