#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/mman.h>
#include <gcrypt.h>
#include <sqlite3.h>
#include <time.h>
#include <xenctrl.h>
#include <pthread.h>

#define MAX_PAGE_NUM 4745

#define rdtscll(val) \
     __asm__ __volatile__("rdtsc" : "=A" (val))

unsigned char *build_memory_map(uint32_t domain);
xen_pfn_t *get_p2m_table(int xc_handle, uint32_t dom);
xen_pfn_t *get_m2p_table(int xc_handle, uint32_t dom);

void *patagonix_handle;
int xc_handle, dom;
struct patagonix_info *info;
struct patagonix_time *times;
uint64_t patagonix_info_frame;
uint64_t patagonix_time_frame;
static xen_pfn_t *live_p2m;
static xen_pfn_t *live_m2p;
unsigned long p2m_size;	
unsigned char *memory_map;
int round_num;
int dcount;
int socket_talk;
pthread_t send;

struct node{
	struct node *next;
	int num;
	unsigned long pages[341];
};

struct node *list;

struct patagonix_entry {
	unsigned long mfn;
	unsigned long cr3;
	unsigned long va;
};

struct patagonix_info {
	unsigned long count;
	struct patagonix_entry entries[341];
};

struct patagonix_time {
	unsigned long count;
	unsigned long long time[341];
};

int get_shared_page(int dom,int xc_handle){
	unsigned long patagonix_info_frame;

	xc_dominfo_t info;

	if(xc_domain_getinfo(xc_handle,dom,1,&info)!=1) {
		printf("Unable to get info\n");
		exit(-1);
	}

	return 0;
}

char *hash_page(unsigned char *data)
{
    //unsigned int PAGE_SIZE = 0x1000;
    /* Length of resulting sha1 hash - gcry_md_get_algo_dlen
     * returns digest lenght for an algo */
    int hash_len = gcry_md_get_algo_dlen( GCRY_MD_SHA1 );

    /* output sha1 hash - this will be binary data */
    unsigned char hash[ hash_len ];

    /* output sha1 hash - converted to hex representation
     * 2 hex digits for every byte + 1 for trailing \0 */
    char *out = (char *) malloc( sizeof(char) * ((hash_len*2)+1) );
    char *p = out;

    /* calculate the SHA1 digest. This is a bit of a shortcut function
     * most gcrypt operations require the creation of a handle, etc. */
    gcry_md_hash_buffer( GCRY_MD_SHA1, hash, data, PAGE_SIZE );

    /* Convert each byte to its 2 digit ascii
     * hex representation and place in out */
    int i;
    for ( i = 0; i < hash_len; i++, p += 2 ) {
        snprintf ( p, 3, "%02x", hash[i] );
    }

   return out;
   //return *hash;
}

void my_handler(int s) {
	printf("caught signal %d\n",s);
	xc_patagonix_destroy(&patagonix_handle);
	exit(1);
}

void send_pages(){

	while(1)
	{
		if(list != NULL)
		{

		}
	}
}

int main(int argc, char **argv) 
{

	int frc,errno,rc;

	signal(SIGINT,my_handler);

	dom = atoi(argv[1]);

	if((socket_talk = sconnect(argv[2],argv[3])) < 0) {
		printf("sconnect error\n");
		exit(1);
	}

	live_p2m = NULL;
	live_m2p = NULL;

	round_num = 0;

	xc_handle = xc_interface_open();

	if(xc_handle == -1) {
		fprintf(stderr, "Unable to get handle to hypervisor\n");
		exit(-1);
	}
	
	memory_map = (unsigned char *)build_memory_map(dom);
	live_p2m = (xen_pfn_t *) get_p2m_table(xc_handle, dom);
	live_m2p = (xen_pfn_t *) get_m2p_table(xc_handle, dom);

	p2m_size = xc_memory_op(xc_handle, XENMEM_maximum_gpfn, &dom) + 1;


	if(xc_patagonix_get_shared_page(xc_handle,dom,&patagonix_info_frame, &patagonix_time_frame) < 0) {
		fprintf(stderr, "Unable to get patagonix shared page\n");
		exit(-1);
	}

	info = (struct patagonix_info *)xc_map_foreign_range(xc_handle, dom,
						0x1000, 
						PROT_READ | PROT_WRITE,
						patagonix_info_frame);

	times = (struct patagonix_time *)xc_map_foreign_range(xc_handle, dom,
						0x1000, 
						PROT_READ | PROT_WRITE,
						patagonix_time_frame);

	/* Live suspend. Enable log-dirty mode. */
	if ( xc_shadow_control(xc_handle, dom,
							XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
							NULL, 0, NULL, 0, NULL) < 0 )
	{
		/* log-dirty already enabled? There's no test op,
		 * so attempt to disable then reenable it */
		frc = xc_shadow_control(xc_handle, dom, 
					XEN_DOMCTL_SHADOW_OP_OFF,
					NULL, 0, NULL, 0, NULL);
		if ( frc >= 0 )
		{
			frc = xc_shadow_control(xc_handle, dom,
									XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
									NULL, 0, NULL, 0, NULL);
		}

		if ( frc < 0 )
		{
			fprintf(stderr,"Couldn't enable shadow mode (rc %d) (errno %d)", frc, errno );
			exit(-1);
		}
	}

	patagonix_handle = (void *)xc_patagonix_prepare(xc_handle,dom);
	
	if(patagonix_handle == NULL)
		printf("Unable to get patagonix handle\n");

	int start = xc_patagonix_start(patagonix_handle);
	if (start < 0)
		printf("Unable to start patagonix\n");
i
	pthread_create(&send,NULL,send_pages,NULL);

	dcount = 0;
	
	while(1)
	{	
		char request[10];
		char response[10];
		memset(request,0,10);
		memset(response,0,10);
	
		xc_patagonix_wait(patagonix_handle);
	
		xc_domain_pause(xc_handle, dom);
	
		int num_pages = info->count;
		sprintf(request,"%d",num_pages);

		int result;
		result = correct_write(socket_talk, request, 10);
		if(result == 10){
			result = correct_read(socket_talk,response,10);
		}
		
		printf("requested %d pages\n",num_pages);		

		char *buffer = malloc(num_pages *0x1000);
		memset(buffer,0,num_pages *0x1000);

		while(dcount < info->count){
	
		//	printf("cr3: 0x%lx mfn: 0x%lx va: 0x%lx\n",
		//		info->entries[dcount].cr3,
		//		info->entries[dcount].mfn,
		//		info->entries[dcount].va);			
			
			unsigned long mach = info->entries[dcount].mfn;
			uint32_t pfn = live_m2p[mach];			
			memcpy(buffer+dcount*0x1000,memory_map+pfn*0x1000, 0x1000);	

			dcount++;	
		}
	
		// send pages;
		
		result = correct_write(socket_talk, buffer, num_pages*0x1000);
		if(result == 10){
			result = correct_read(socket_talk,response,10);
		}

		info->count = 0;
		times->count = 0;
		dcount = 0;
	

		printf("done round %d\n",round_num);	
		round_num++;
		
		xc_domain_unpause(xc_handle,dom);
	}	
}

