
#include <ucontext.h>

enum states{READY,BLOCKED,FINISHED};

typedef struct thread_t {

	int tid,state;
	void *func, *arg;
	ucontext_t context;
	char stack[SIGSTKSZ];

}thread_t;

typedef struct node {
	thread_t *thread;
	struct node *next;
	//struct node *previous;
}node;

/*
 * thread_list is meant to be a circular queue.  The tail will
 * always point to the head of the list.  When a node is added it
 * is added to the end of the list in FIFO fashion.
 */
typedef struct thread_list {
	int size;
	node *head;
	node *tail;

}thread_list;

typedef struct thread_attr_t {
	void *attr;
}thread_attr_t;

typedef struct thread_mutex_t {
	int lock;
	thread_list *mutex_blocked;
}thread_mutex_t;

typedef struct thread_mutexattr_t {
	void *attr;
}thread_mutexattr_t;

typedef struct thread_cond_t {
	int id;
	int signal;
	thread_list *cond_blocked;
}thread_cond_t;

typedef struct thread_condattr_t {
	void *attr;
}thread_condattr_t;



int thread_create(thread_t *thread, thread_attr_t *attr, void *(*start_routine)(void*), void *arg);
void thread_exit();
void tsched_yield();
int thread_cond_init(thread_cond_t *cond, const thread_condattr_t *attr);
int thread_cond_broadcast(thread_cond_t *cond);
int thread_cond_signal(thread_cond_t *cond);
int thread_cond_wait(thread_cond_t *cond, thread_mutex_t *mutex);
int thread_mutex_init(thread_mutex_t *mutex, const thread_mutexattr_t *attr);
int thread_mutex_lock(thread_mutex_t *mutex);
int thread_mutex_unlock(thread_mutex_t *mutex);




