#!/usr/bin/python
import sys

if len(sys.argv) < 3:
    print "GIVE ME ONE FILE AS FIRST ARG AND MAX TIME AS SECOND ARG"
    sys.exit(1)

VOLTAGE             = 5.0
CONV_JOULES_TO_mWH  = (5.0 / 18.0)
#AMP_UNITS           = (1.0 / 1000.0) # assume input is miliAmps
AMP_UNITS           = (1.0)
TIME_UNITS          = (1.0)
MAX                 = float(sys.argv[2])

def trapezoid(a, b):
    """Take two lists a and b such that a = [x_a, f_a], where
       x_a is the x axis value (time when sampled) and f_a is 
       the y axis value (the sample)"""
    x_a = a[0]
    f_a = a[1]
    x_b = b[0]
    f_b = b[1]
    return (x_b - x_a) * ((f_a + f_b) / 2.0)

lines   = [x.strip().split() for x in open(sys.argv[1], 'r').readlines()]
vals    = map(lambda x:map(float, x), lines)

integral = 0.0
for i in range(len(vals) - 1):
    if float(lines[i][0]) < MAX:
        integral = integral + trapezoid(vals[i], vals[i+1])

integral_joules = integral * VOLTAGE * AMP_UNITS * TIME_UNITS
print '%f %f' % (integral_joules, integral_joules * CONV_JOULES_TO_mWH)
