import sys

# Usage: python print_mappings.py <node probabilities file> <node_list> <android BBs> <j2me BBs> <mappings>
# <node probabilities file> : input file having <node number, probability (of mapping being false, of mapping being true)>
# <node_list> : input file having a list of <node number, mapping it represents>. 
#		Mapping is in the form (android BB number, j2me BB number).
# <android_BBs> : input file having a numbered list of android BBs
# <j2me BBs> : input file having a numbered list of j2me BBs.
# <mappings> : output file in which the mappings are written
# <numbers>  : output file in which numbered mappings are written

# check number of arguments
if (len(sys.argv) != 6):
    print "# Usage: python all_runs_print_mappings.py <node probabilities file> <android BBs> <j2me BBs> <mappings> <numbers>"  
    sys.exit()

nodeProbList = []

# read the node numbers and probabilities 

# values[0] = j2me node
# values[1] = android node
# values[2] = Prob. of being false
# values[3] = Prob. of being true

for line in open(sys.argv[1],'r'):
   values = line.split()
   nodeProbList.append( [ int(values[0]), int(values[1]), values[2], values[3], float(values[4]), int(values[5]) ] )

# read the numbered android BBs
androidBBList = []
entry = ''
i = 0
for line in open(sys.argv[2],'r'):
   if (len(line) == 1):
        continue
   if (line[-2] != '*'):
        entry += line
   elif (entry != ''):
        androidBBList.append([i, entry])
        i += 1
        entry = ''


j2meBBList = []

# read the numbered j2me BBs
entry = ''
i = 0
for line in open(sys.argv[3],'r'):
   if (len(line) == 1):
        continue
   if (line[-2] != '*'):
        entry += line
   elif (entry != ''):
        j2meBBList.append([i, entry])
        i += 1
        entry = ''

# search and print
# for each element in node probability list,
#	search the element in the node list 
#	get the (android BB number, j2me BB number) entry for the element
# 	search for the string corresponding to android BB
#	search for the string corresponding to j2me BB
#	print (android BB string <-------> j2me BB string)	

numbersFile = open(sys.argv[5], 'w');
mappingsFile = open(sys.argv[4], 'w');
i = 0
mappingsFile.write("*******************  " + str(i+1) +"  *******************\n")
# start of "i while" loop
while (i < len(nodeProbList)):

   android_BB = nodeProbList[i][1]

   # search for this BB in androidBBList
   k = 0
   while (k < len(androidBBList)):
	if (androidBBList[k][0] == android_BB):
	    break
	else:
	    k += 1
   if (k >= len(androidBBList)):
	print "Error: Android BB " + android_BB + " Not found"
	sys.exit()

   j2me_BB = nodeProbList[i][0]

   # search for this BB in j2meBBList
   l = 0
   while (l < len(j2meBBList)):
	if (j2meBBList[l][0] == j2me_BB):
	    break
	else:
	    l += 1
   if (l >= len(j2meBBList)):
	print "Error: j2me BB " + j2me_BB + " Not found"
	sys.exit()

   k = android_BB
   l = j2me_BB

# simple output meant as input to other programs
   outstring = str(j2meBBList[l][0]) + " " + str(androidBBList[k][0]) + " " + str(nodeProbList[i][2]) + " " + str(nodeProbList[i][3]) + " " + str(nodeProbList[i][4]) + " " + str(nodeProbList[i][5]) + "\n"
   numbersFile.write(outstring)
   

# Decorated output readable for humans
   
   mappingsFile.write("||||||||||||||||||||||||||||||||||||||\n")
   mappingsFile.write("**************************************\n")
   mappingsFile.write(j2meBBList[l][1])
   mappingsFile.write("\n**************************************\n")
   mappingsFile.write(androidBBList[k][1])
   mappingsFile.write("\n***************** " + str(i+2) + " *********************\n")

   i+= 1

# end of "i while" loop

mappingsFile.write("||||||||||||||||||||||||||||||||||||||\n")

mappingsFile.close()

numbersFile.close()
