import sys

# Usage: python aggregate/combine_across.py <file having names of numbers file> > <file in which redirected output is written>

#- Do for each file
#-  read mapping from the file
#-  read the first BB of the mapping. Let X = BB just read
#-  if this is the first mapping from the file, set current BB = X
#-  If (X == current BB), add mapping to the currentList
#-  else 
#-      find the list among global lists whose first BB matches with currentBB. 
#-	If (list found) 
#-	    let this list be list(currentBB)
#- 	    find ( list(currentBB) ) intersection with ( currentList )
#- 	    Make this intersection as the new list in the global list, removing the older list(currentBB) from the global list
#-	else 
#-	    Add currentList to the lists in the global list
#-	start a new currentList with the mapping just read and set currentBB = first BB

# for four files num00, num00n, num10, num10n 
# - find ( num00 intersection num10 )
# - find ( num00 - ( num10 + num10n ) ) i.e. mappings present in num00 but neither present in num10 nor in num10n
# - find ( num10 - ( num00 + num00n ) ) i.e. mappings present in num10 but neither present in num00 nor in num00n
# - union of the above three terms = new "numX0" file
# - new "numX0n" file = union ( num00n , num10n )

# functions :
# - to find intersection
# - to find union
# - to find subtraction

# input: 
#    list : of the form ([23, 12], [67, 78], ...) i.e. 2-D array with each entry having two elements
#    memberArray : of the form [34, 45]. i.e. 1-D array with two elements
# return value: returns index i in the array where memberArray was found

def LowerOfTheTwo(num1, num2):
   if (num1 < num2):
	return num1
   else: 
	return num2


def intersection(list1, list2):
# format : first[0] = j2meBB androidBB FalseProbability TrueProbability
   i = 0
   j = 0
   intrsctList = []
   while ( (i < len(list1)) and (j < len(list2)) ): 
   	currentFirst = list1[i][0]
   	currentSecond = list2[j][0]
	while (currentFirst != currentSecond):
	    if (currentFirst < currentSecond):
	    	i += 1
		if (i >= len(list1)):
		    break
	    	currentFirst = list1[i][0]
	    elif (currentFirst > currentSecond):
	    	j += 1
		if (j >= len(list2)):
		    break
	    	currentSecond = list2[j][0]
# At this point, either (currentFirst = currentSecond) or we have gone beyond list1 or list2.
   	if ((i != len(list1)) and (j != len(list2)) ):
	    currentJ2ME = currentFirst
	    k = i
# for each tuple in list1 starting from list1[i], find the tuple in list2 starting from list2[j]		
	    while ( (k < len(list1)) and (list1[k][0] == currentJ2ME) ):
	    	foundIndex = findInList(list2, list1[k], j)
	    	if (foundIndex != -1):
#	    	    falseProb = round( float((list1[k][2] + list2[foundIndex][2])/2) , 4)
#		    falseProb = round ( float (LowerOfTheTwo(list1[k][2], list2[foundIndex][2])), 4 )
#	    	    falseProb = list1[k][2] + list2[foundIndex][2] 
#	    	    intrsctList.append( [ list1[k][0], list1[k][1], falseProb, 1 - falseProb , list1[k][4]+list2[foundIndex][4] ] )
	    	    trueProb = list1[k][3] + list2[foundIndex][3] 
	    	    intrsctList.append( [ list1[k][0], list1[k][1], 1 - trueProb, trueProb, list1[k][4]+list2[foundIndex][4], list1[k][5]+1 ] )
	    	    #print "[", list1[k][0], list1[k][1], falseProb, 1 - falseProb, "]" 
		k += 1
	    i = k 
	    while (j < len(list2)):
	    	if (list2[j][0] == currentJ2ME):
		    j += 1
	    	else:
		    break
	    #print "( i, j )=", i, j

   return intrsctList

def union(list1, list2):
# format : first[0] = j2meBB androidBB FalseProbability TrueProbability
   i = 0
   j = 0
   unionList = []
   while ( (i < len(list1)) and (j < len(list2)) ): 
   	currentFirst = list1[i][0]
   	currentSecond = list2[j][0]
	while (currentFirst != currentSecond):
	    if (currentFirst < currentSecond):
		unionList.append( [ list1[i][0], list1[i][1], list1[i][2], list1[i][3], list1[i][4], list1[i][5] ] )
	    	i += 1
		if (i >= len(list1)):
		    break
	    	currentFirst = list1[i][0]
	    elif (currentFirst > currentSecond):
		unionList.append( [ list2[j][0], list2[j][1], list2[j][2], list2[j][3], list2[j][4], list2[j][5] ] )
	    	j += 1
		if (j >= len(list2)):
		    break
	    	currentSecond = list2[j][0]
# At this point, either (currentFirst = currentSecond) or we have gone beyond list1 or list2.
   	if ((i != len(list1)) and (j != len(list2)) ):
	    currentJ2ME = currentFirst
	    k = i
# for each tuple in list1 starting from list1[i], find the tuple in list2 starting from list2[j]		
	    while ( (k < len(list1)) and (list1[k][0] == currentJ2ME) ):
	    	foundIndex = findInList(list2, list1[k], 0)
	    	if (foundIndex != -1):
#	    	    falseProb = round( float((list1[k][2] + list2[foundIndex][2])/2) , 4)
#		    falseProb = round ( float(LowerOfTheTwo(list1[k][2], list2[foundIndex][2])), 4 )
#	    	    falseProb = list1[k][2] + list2[foundIndex][2]
#	    	    unionList.append( [ list1[k][0], list1[k][1], falseProb, 1 - falseProb, list1[k][4]+list2[foundIndex][4] ] )
	    	    trueProb = list1[k][3] + list2[foundIndex][3] 
	    	    unionList.append( [ list1[k][0], list1[k][1], 1 - trueProb, trueProb, list1[k][4]+list2[foundIndex][4], list1[k][5]+1 ] )
	    	    #print "[", list1[k][0], list1[k][1], falseProb, 1 - falseProb, "]" 
		else: #foundIndex == -1
		    unionList.append( [ list1[k][0], list1[k][1], list1[k][2], list1[k][3], list1[k][4], list1[k][5] ] )
		k += 1
	    m = j
	    while ( (m < len(list2)) and (list2[m][0] == currentJ2ME)):
	    	foundIndex = findInList(list1, list2[m], 0)
	    	if (foundIndex == -1):
	    	    #print "[", list2[m][0], list2[m][1], list2[m][2], list2[m][3], "]" 
		    unionList.append( [ list2[m][0], list2[m][1], list2[m][2], list2[m][3], list2[m][4], list2[m][5] ] )
		m += 1

	    i = k
	    j = m
	    #print "( i, j )=", i, j
   while (i < len(list1)):
	unionList.append( [ list1[i][0], list1[i][1], list1[i][2], list1[i][3], list1[i][4], list1[i][5] ] )
	i += 1
   while (j < len(list2)):
	unionList.append( [ list2[j][0], list2[j][1], list2[j][2], list2[j][3], list2[j][4], list2[j][5] ] )
	j += 1

   return unionList

def subtraction(list1, list2):
# format : first[0] = j2meBB androidBB FalseProbability TrueProbability
   i = 0
   j = 0
   subtractList = []
   while ( (i < len(list1)) and (j < len(list2)) ): 
   	currentFirst = list1[i][0]
   	currentSecond = list2[j][0]
	while (currentFirst != currentSecond):
	    if (currentFirst < currentSecond):
		subtractList.append( [ list1[i][0], list1[i][1], list1[i][2], list1[i][3], list1[i][4], list1[i][5] ] )
	    	i += 1
		if (i >= len(list1)):
		    break
	    	currentFirst = list1[i][0]
	    elif (currentFirst > currentSecond):
	    	j += 1
		if (j >= len(list2)):
		    break
	    	currentSecond = list2[j][0]
# At this point, either (currentFirst = currentSecond) or we have gone beyond list1 or list2.
   	if ((i != len(list1)) and (j != len(list2)) ):
	    currentJ2ME = currentFirst
	    k = i
# for each tuple in list1 starting from list1[i], find the tuple in list2 starting from list2[j]		
	    while ( (k < len(list1)) and (list1[k][0] == currentJ2ME) ):
	    	foundIndex = findInList(list2, list1[k], 0)
	    	if (foundIndex == -1):
	    	    subtractList.append( [ list1[k][0], list1[k][1], list1[k][2], list1[k][3], list1[k][4], list1[k][5] ] )
	    	    #print "[", list1[k][0], list1[k][1], list1[k][2], list1[k][3], "]" 
		k += 1
	    i = k 
	    while (j < len(list2)):
	    	if (list2[j][0] == currentJ2ME):
		    j += 1
	    	else:
		    break
	    #print "( i, j )=", i, j
   while (i < len(list1)):
	subtractList.append( [ list1[i][0], list1[i][1], list1[i][2], list1[i][3], list1[i][4], list1[i][5] ] )
	i += 1

   return subtractList 


def combineProbs(list):
   j = 0
   val = 0
   while (j < len(list)):
	val += list[j]
	j += 1  
	
   val = round(val/j, 2)

   return val


def findInList(list, memberArray, start):
   i = start 
   while (i < len(list)):
	if ((list[i][0] == memberArray[0]) and (list[i][1] == memberArray[1])):
	    return i
	else:	
	    i += 1
   return -1

# Global list should be a 2-D array. glblList[0] : List having mappings for a particular BB, say X.
# So, glblList[0][1] : Mapping (X, a1) glblList[0][2] : Mapping (X, a2) and so on. 

# start
# error checking
if (len(sys.argv) != 5):
    print "# Usage: python aggregate/script.py <file having names of numbers file> <initialization traces file> <output file for allnums> <output file for allnums_n>"
    sys.exit()

numlist1 = []
numlist2 = []
numlist1n = []
numlist2n = []

lst = 1
for filename in open(sys.argv[2],'r'):
   filename = filename.rstrip('\n')
   for line in open(filename,'r'):
        values = line.split()
        if (lst == 1):
            numlist1n.append([ int(values[0]), int(values[1]), float(values[2]), float(values[3]), float(values[4]), 1 ])
        if (lst == 2):
	    trueProb = float(values[3]) * float(values[4]) 
#            numlist1.append([ int(values[0]), int(values[1]), float(values[2]), float(values[3]), 1 ])
            numlist1.append([ int(values[0]), int(values[1]), 1 - trueProb, trueProb, float(values[4]), 1 ])
   lst += 1 	

lst = 1
for filename in open(sys.argv[1],'r'):
   filename = filename.rstrip('\n')
   for line in open(filename,'r'):
	values = line.split()

# values[0] = j2me node
# values[1] = andriod node
# values[2] = Prob. of being false
# values[3] = Prob. of being true
	if (lst%2 == 1): # if lst == odd
	    numlist2n.append([ int(values[0]), int(values[1]), float(values[2]), float(values[3]), float(values[4]), 1 ])
	if (lst%2 == 0): # if lst == even
	    trueProb = float(values[3]) * float(values[4]) 
#	    numlist2.append([ int(values[0]), int(values[1]), float(values[2]), float(values[3]), 1 ])
	    numlist2.append([ int(values[0]), int(values[1]), 1 - trueProb, trueProb, float(values[4]), 1 ])
   lst += 1 
   if (lst%2 == 0):
	continue

   p1 = intersection(numlist1, numlist2)
   p2 = subtraction(numlist1, union(numlist2, numlist2n))
   p3 = subtraction(numlist2, union(numlist1, numlist1n))
   p4 = union(p2, p3)
   numlist1 = union(p1, p4)
   numlist1 = sorted(numlist1, key=lambda entry: (entry[0], entry[1]) );
   numlist1n = union(numlist1n, numlist2n)
   numlist1n = sorted(numlist1n, key=lambda entry: (entry[0], entry[1]) );
   numlist2 = []
   numlist2n = []

## False prob = 1 - s1p1 + 1 - s2p2 + and so on..
# Divide it by the number of sipi's
i = 0
while (i < len(numlist1)):
   numlist1[i][3] = float(numlist1[i][3]/numlist1[i][4])
   numlist1[i][2] = 1 - numlist1[i][3]
   i += 1

numlist1 = sorted(numlist1, key=lambda entry: (entry[0], entry[3]), reverse=True )
allnumFile = open(sys.argv[3], 'w');
i = 0
prev_j2meBB = numlist1[0][0]
same_j2meBB_count = 0

while (i < len(numlist1)):
   j2meBB = numlist1[i][0]
   if (j2meBB == prev_j2meBB):
	same_j2meBB_count += 1
   else:
	same_j2meBB_count = 1	
        prev_j2meBB = numlist1[i][0]
   if (same_j2meBB_count <= 10 ):
   	s = str(numlist1[i][0]) + " " + str(numlist1[i][1]) + " " + str(numlist1[i][2]) + " " + str(numlist1[i][3]) + " " + str(numlist1[i][4]) + " " + str(numlist1[i][5]) + "\n"
   	allnumFile.write(s)
   i += 1

allnumFile.close()

allnum_n_File = open(sys.argv[4], 'w');
i = 0
while (i < len(numlist1n)):
   s = str(numlist1n[i][0]) + " " + str(numlist1n[i][1]) + " " + str(numlist1n[i][2]) + " " + str(numlist1n[i][3]) + " " + str(numlist1n[i][4]) + " " + str(numlist1n[i][5]) + "\n"
   allnum_n_File.write(s)
   i += 1

allnum_n_File.close()

#print "-----------------------------------------------------------------------------------------------------"
#i = 0
#while (i < len(numlist1n)):
#   print numlist1n[i][0], numlist1n[i][1], numlist1n[i][2], numlist1n[i][3]
#   i += 1


# end of "for line in"
# end of "for filename in"	

