import sys
import operator
import cProfile
import string
# Usage: $python common_substring.py <file having names of trace files> > <redirected output written into this file which holds the BBs.> 
#
# Given a list of trace files, this program computes the BBs across all the provided traces.
#

# If long_substr returns "" as the common substring for a pair (string1, string2) of two strings, then you should never call long_substr with these same two strings as the argument.

# input: array with array[1], array[2] having string1, string2. You want to find longest common subsequence between the two strings : string1 and string2.
# output: longest common subsequence between the two input strings 

def long_substr(data):
    if (data[0] in data[1]):
	return data[0]
    if (data[1] in data[0]):
	return data[1] 
    substr = ''
    substr_len = len(substr)
    if len(data) > 1 and len(data[0]) > 0:
	str_1_len = len(data[0])
	i = -1
        while (i < str_1_len-1):
	    i += 1
	    if (data[0][i] != '*'):
		continue   
	    max_substr_len = str_1_len - i + 1
	    j = -1
            while (j < max_substr_len-1):    
		j += 1
		#if j > substr_len and all(data[0][i:i+j] in x for x in data):
		if (data[0][i+j-1] != '\n'):
			continue;
		if (j > substr_len) and (data[0][i:i+j] in data[1] ) :
                    substr = data[0][i:i+j]
    	            substr_len = len(substr)

    #print "at first substr=", substr
    if (len(substr) > 0):
      if (substr[-1] != '\n'):
	# Remove the rightmost characters from the string till you encounter a '*'. Remove that '*' too.
	i = -1
	while (-i < len(substr)):
	    #print "i=", i, "char=", substr[i]
	    if (substr[i] == '*'):
		break;
	    else:
	        i = i-1
        if (-i == len(substr)):
            substr = ""
        else:
	    substr = substr[:i]
    if (len(substr) > 0):
      if (substr[0] != '*'):
        # Remove the starting characters from the string till you encounter a '*'. keep that '*' though.
        i = 0 
	while (i < len(substr)):
            #print "i=", i, "char=", substr[i]
	    if (substr[i] == '*'):
	        break
	    else:
		i = i+1
        if (i == len(substr)):
	    substr = ""
        else:
	   substr = substr[i:] 

    if (len(substr) > 0):
        #print "substr=", substr, "last=", substr[-1], "first=", substr[0]
        if (operator.or_(substr[0] != '*', substr[-1] != '\n')):
	       substr = ""
    #print "substr at last=", substr, "end"
    return substr

def all_substr(file1):
    ws = []
    for filename in open(file1,'r').readlines():
        filename = filename.rstrip('\n')
        f = open(filename, 'r') 
	contents = f.read()
	f.close()
        ws.append(contents)
    # Error checking
    i = 0
    while (i < len(ws)):
       string = ws[i]
       if (string[0] != '*'):
           print "******************************************************************"
 	   print "File" + i + " not in the expected format. Strings don't have a '*' prepended to them."
	   print string[0]
	   print "******************************************************************"
       i = i+1
# add the common substring to the array
# for each of the two strings, split them as {s1, substr, s2}. Add s1, s2 to array and remove the original string from the array
# choose two strings from ws, and call long_substr() for these two strings
    nochange = 0
    disjoint_str = set([])
    k = -1
    while (nochange == 0):
        i = 0
        nochange = 1
        while (i < len(ws)):
	    #print "len=", len(ws)
	    j = i+1
	    while (j < len(ws)):
	        string1 = ws[i]
	        string2 = ws[j]
	        #print "i=", i, "j=", j, "string1=", string1, "string2=", string2
		if (string1[-1] != '\n') or (string1[0] != '*'):
		    j = len(ws)
		    break
		elif (string2[-1] != '\n') or (string2[0] != '*'):
	            new_string = ""
		else:
#		    disjoint = 0
#		    l = 0
#		    while (l <= k):
#			if (disjoint_str[l][0] == string1 and disjoint_str[l][1] == string2):
#			    disjoint = 1
#			    break;
#			else:
#			    l += 1
		    if (((string2, string1) in disjoint_str) or ((string1, string2) in disjoint_str)):
#		    if (disjoint == 1):
			new_string = ""
		    else:
		        if (len(string1) > len(string2)):
		            new_string = long_substr([string2, string1])
	                else:
		            new_string = long_substr([string1, string2])
		        if (new_string == ""):
	    		    k += 1
			    disjoint_str.add((string1, string2))
		    	    #disjoint_str.append([])
		    	    #disjoint_str[k].append(string1)		
		    	    #disjoint_str[k].append(string2)		
		        #print "string 1=", string1, "string 2=", string2, "last=", string2[len(string2)-1]
# if all the strings are either empty strings or have length >= 2
# i.e. if len(s1[0]) != 1 && len(s1[2] != 1) && len(s2[0]) != 1 && len(s2[1]) != 1 && len(new_string) != 1
                if (new_string != ""):
		    #print "new_string=", new_string
            	    s1 = string1.partition(new_string)
            	    s2 = string2.partition(new_string)
	    	    if (s1[0] != ""):
            	        ws.append(s1[0])
	    	    if (s1[2] != ""):
            	        ws.append(s1[2])
	    	    if (s2[0] != ""):
            	        ws.append(s2[0])
	    	    if (s2[2] != ""):
            	        ws.append(s2[2])
		    ws.append(new_string)
	    	    ws.remove(string1)
	    	    ws.remove(string2)
		    nochange = 0
		    # Go back to the start of the loop for i 
		    j = len(ws)
		    i = len(ws)
	    	    #print ws
	        j=j+1
            i=i+1

    return ws

#print all_substr('/home/amruta/Tests/APIMapping/Jan29/TracesForBBs/TicTacToe/0/data.parsed.txt',
#                  '/home/amruta/Tests/APIMapping/Jan29/TracesForBBs/TicTacToe/1/data.parsed.txt')
#print sys.argv[1]
if (len(sys.argv) != 2):
    print "# Usage: $python common_substring.py <file having names of trace files> > <redirected output written into this file which holds the BBs.>"
    sys.exit() 

cProfile.run('bb = all_substr(sys.argv[1])', 'outProfile')
i = 0
print "******************************************************************"
while (i < len(bb)):
    string = '"'+ bb[i] + '"'
    print bb[i]
    print "******************************************************************"
    i = i+1

#print bb
