import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class InstrumentPrintf {

	private static byte[] instrument(final InputStream input) throws IOException {
	    ClassReader cr = new ClassReader(input);
		ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS);
		//ClassVisitor cv = new ClassAdapter(cw);
		ClassVisitor cv = new PrintfClassVisitor(cw);
		//TraceClassVisitor tcv = new TraceClassVisitor(cv, new PrintWriter(System.out));
		cr.accept(cv, 0);

		return cw.toByteArray();
		//(new FileOutputStream(outputFile)).write(cw.toByteArray());		
	}
	
	private static void processJar(File jarInputFile, File jarOutputFile) throws IOException {
		JarInputStream jis = null;
		JarOutputStream jos = null;
		try {
			jis = new JarInputStream(new FileInputStream(jarInputFile));
			Manifest manifest = jis.getManifest();
			if (manifest == null) {
				jos = new JarOutputStream(new FileOutputStream(jarOutputFile));
			} else {
				jos = new JarOutputStream(new FileOutputStream(jarOutputFile), manifest);
			}
			byte[] inBuffer = new byte[200000];
			byte[] outBuffer;
			JarEntry jarEntry;			
			while ((jarEntry = jis.getNextJarEntry()) != null) {
				String jarName = jarEntry.getName();
				int size = 0;
				int read;
				int length = inBuffer.length;
				while ((read = jis.read(inBuffer, size, length-size)) > 0) {
					size += read;
					/*
					length = 1024;
					if (size + length > inBuffer.length) {
						byte[] newInputBuffer = new byte[size + length];
						System.arraycopy(inBuffer, 0, newInputBuffer, 0, inBuffer.length);
						inBuffer = newInputBuffer;
					}*/
				}
				outBuffer = inBuffer;
				if (jarName.endsWith(".class")) {					
					outBuffer = instrument(new ByteArrayInputStream(inBuffer,0,size));
					jos.putNextEntry(new JarEntry(jarName));
					jos.write(outBuffer, 0, outBuffer.length);
				}
				else
				{					
					jos.putNextEntry(new JarEntry(jarName));
					jos.write(outBuffer, 0, size);
				}
			}
			
			
		} finally {
			if (jis != null) {
				jis.close();
			}
			if (jos != null) {
				jos.close();
			}
		}
		
		
		
	}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 2 || args.length > 3) {
			System.out.println("usage: InstrumentPrintf <infile> <outfile>");			
		} else {
			try {
				processJar(new File(args[0]), new File(args[1]));
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

}
