import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;


public class SingleFileInstrument {
	
	private static void process(File inputFile, File outputFile) throws IOException {
		
	    ClassReader cr = new ClassReader(new FileInputStream(inputFile));
		ClassWriter cw = new ClassWriter(0);
		//ClassVisitor cv = new ClassAdapter(cw);
		ClassVisitor cv = new PrintfClassVisitor(cw);
		cr.accept(cv, 0);
		
		(new FileOutputStream(outputFile)).write(cw.toByteArray());
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 2 || args.length > 3) {
			System.out.println("usage: InstrumentPrintf <infile> <outfile>");			
		} else {
			try {
				process(new File(args[0]), new File(args[1]));
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
}
