/* Functions performing bytes operations */ 
#include "global.h"

extern int count_sends;
extern FILE * fdout;


/* Dumps 4K size bytes in file log/bytes.txt */
void dump_bytes(unsigned char * ptr)
{
    int i;
    int chunk_size = (SLAB_SIZE / 2);
	FILE * fd_bytes;

	fd_bytes = fopen("log/bytes.txt","a");
	if(fd_bytes == NULL)
	{
		printf("Cannot open file log/bytes.txt \n");
		exit(-1);
	}
                                                                                                                                               
    for(i=0; i< chunk_size; i++)
    {
        fprintf(fd_bytes, "%x ", *(unsigned char *)(ptr + i));
    }

	fclose(fd_bytes);
}

/* Prints the secure hash passed as argument */
void print_secure_hash(FILE *fd, unsigned char * hash)
{
     int i;
                                                                                                                                               
     for(i=0;i<SECURE_HASH_BUFFER_LEN; i++)
     {
         fprintf(fd,"%02X ",hash[i]);
     }
}

/* Copies num_bytes from src to dest */
void copy_bytes(unsigned char * src, unsigned char * dest, int num_bytes, int start_pos)
{
    int i;

    if(src == NULL)
        printf("src is null\n");
    
    if(dest == NULL)
	printf("dest is null\n");

    for(i=start_pos; i< (start_pos + num_bytes); i++){
		dest[i] = src[i];
	}
}
                                                                                                                                               
/* Prints num_bytes bytes to a given file */
void print_bytes(FILE * fd, unsigned char * src, int num_bytes, int start_pos)
{
    short i;
                                                                                                                                               
    for(i=start_pos; i< (start_pos + num_bytes); i++)
    {
        fprintf(fd, "%02X ", *(unsigned char *)(src + i));
        if(((i % 16) == 0) && (i > 0))
        {
            fprintf(fd, "%s", "\n");
        }
    }
}
                                                                                                                                               
/* Compares two hash values */
int compare_hash(unsigned char * src, unsigned char * dest)
{
    int i;
    int ret = 1;
    for(i=0; i<SECURE_HASH_BUFFER_LEN; i++)
    {
        if(src[i] != dest[i])
        {
            ret = 0; //Does not match
            return(ret);
        }
    }
    return(ret); //Matches
}
