/* Functions that generate the Daikon traces are clubbed together in this file */

#include "global.h"

extern int get_array_index(const char * ptr);

string get_daikon_type(string strip_type);
extern string replace_spaces(string ip_type);
extern bool func_ptr(char * s);

/* Generates the daikon declaration file in intermediate format */
void create_daikon_declaration(vector<field_t> fields, string prefix, int msmt_round, string sym_type)
{
	std::stringstream strfilter;
                                                                                                                                               
    strfilter << msmt_round;
                                                                                                                                               
    string filename = "snapshots/" + prefix;
    filename.append(".ir.decls");

	FILE * fd_filter;

	fd_filter = fopen(filename.c_str(),"w");

	if(fd_filter == NULL)
	{
		cout << "Cannot open file " << filename.c_str() << endl;
		exit(-1);
	}

	fprintf(fd_filter,"DECLARE\n");
	//string ident =  replace_spaces(sym_type);
	//fprintf(fd_filter, "%s:::classdecl\n", ident.c_str());
	//fprintf(fd_filter, "%s%s%s", LEFT_FIELD_DELIMITED,ident.c_str(),RIGHT_FIELD_DELIMITER);
	fprintf(fd_filter, "%s\n", prefix.c_str());

	for(int i=0; i<fields.size(); i++)
    {
       	field_t fld = fields[i];
    	string fld_type = fld.type;
       	string fld_name = fld.name;

		if(strstr(fld_type.c_str(),"union") == NULL)
		{
			if(func_ptr((char *)fld_type.c_str()))
			{
        		fprintf(fd_filter, "%s\n", fld_name.c_str()); //Variable name
			}
			else if((strstr(fld_type.c_str(), "[") != NULL) && (strstr(fld_type.c_str(), "]") != NULL))
			{
				//Name has to suggest it is an array
        		fprintf(fd_filter, "%s[]\n", fld_name.c_str()); //Variable name
			}
			else
			{
        		fprintf(fd_filter, "%s\n", fld_name.c_str()); //Variable name
			}

			string dktype = get_daikon_type(fld_type);
			//fprintf(fd_filter, "%s\n", fld_type.c_str()); //Declaration type

			fprintf(fd_filter, "%s\n", dktype.c_str()); //Daikon declaration type - same as representation type 
			fprintf(fd_filter, "%s\n", dktype.c_str()); //Daikon Representation type
			fprintf(fd_filter, "0\n"); //Comparability
		}
	}
	fclose(fd_filter);
}

/* Function returns the corresponding Daikon type for a C primitive data type */
string get_daikon_type(string strip_type)
{
	bool pointer=false, array=false;
	string ret;
	char ip_type[255];

	strcpy(ip_type,strip_type.c_str());

	if(strstr(ip_type,ATTRIBUTE_STRING) != NULL)
	{
		//First get rid of attr string
		char * tmp = strstr(ip_type,ATTRIBUTE_STRING);
		tmp[0] ='\0';
	}

	if(func_ptr(ip_type))
	{
		//Check if function pointer
		pointer = true;
	}	
	else if(strstr(ip_type, "*") != NULL)
	{
		//Check if it is a pointer of any type	
		pointer = true;
	}

	if((!func_ptr(ip_type)) && ((strstr(ip_type, "[") != NULL) && (strstr(ip_type, "]") != NULL)))
	{
		//Check if it is an array
		array = true;
	}

	if(pointer)
	{
		ret = "hashcode";
	}
	else if((strstr(ip_type,"short") != NULL)  || (strstr(ip_type,"int") != NULL)	|| 
       (strstr(ip_type,"long") != NULL))
	{
		ret ="int";	
	}
	else if((strstr(ip_type,"double") != NULL) || (strstr(ip_type,"float") != NULL))
	{
		ret ="float";	
	}
	else if(strstr(ip_type,"char") != NULL)
	{
		ret ="java.lang.String";	
	}

	if(array)
	{
		/*stringstream tmp;
		tmp <<  get_array_index(ip_type);
		ret = ret + "[" + tmp.str() + "]"; */

		ret = ret + "[]";

	}
	
	return ret;	
}

