#include "global.h"

/* Reads from file input/typedefs.gen and file input/offsets.gen
   and creates an in-memory map of definitions for
   fast access 
*/

void build_typedef_index();
bool is_typedef(const char * str);
const char * resolve_typedef(const char * str);

static map<string,string> typedefs;
extern map<string,definition_t> def_map;
#define ATTR_STRING  "} __attribute__(("

void print_definition_map()
{
	FILE * fdout;

	fdout = fopen("log/defmap.txt","w");
	
	if(fdout == NULL)
	{
		printf("Cannot create file log/defmap.txt\n");
		exit(-1);
	}

	map<string,definition_t>::iterator iter = def_map.begin();

	while(iter!= def_map.end())
	{
		fprintf(fdout,"[%s]\n", (iter->first).c_str());
		definition_t current_def = iter->second;

		for(int j=0; j<current_def.size(); j++)
		{
			field_t current_fld = current_def[j];

			fprintf(fdout,"%s %s %d %d\n", current_fld.name.c_str(), current_fld.type.c_str(), current_fld.offset, current_fld.size);
		}

		iter++;
	}	
	
	fclose(fdout);
}

void build_definition_map()
{
	build_typedef_index();

	FILE * fdtypes;
	FILE * fdoff;
	char buffer[MAX_LINE_INPUT_SIZE];
	char obuf[MAX_LINE_INPUT_SIZE];
	int struct_counter = 0;
	int total_defs_counter =0;
	int union_counter =0;

    fdtypes = fopen("input/typedefs.gen","r");
    if(fdtypes == NULL)
    {
        printf("Cannot open file input/typedefs.gen\n");
        exit(-1);
    }

    fdoff = fopen("input/offsets.gen","r");
    if(fdoff == NULL)
    {
        printf("Cannot open file input/offsets.gen\n");
        exit(-1);
    }
	

	fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
	fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);
	
 	while(!feof(fdtypes))
    {
	//	printf("buffer: %s\n",buffer);
	//	printf("obuf: %s\n",obuf);
		if((strstr(buffer,"struct") != NULL) || (strstr(buffer,"union") != NULL))
		{
			total_defs_counter++;
		//	printf("total_defs: %d\n",total_defs_counter);
			if(strstr(buffer,"{") != NULL)
			{
				//Struct/Union definition encountered
				vector<field_t> vfields;
				char * ptr;
				bool struct_union; //true if struct, false if union

				ptr = strtok(buffer," ");
				string key = ptr;
				ptr = strtok(NULL," ");
				key = key + " " + ptr;

				//cout << "Key =" << key << endl;
				if(strstr(key.c_str(), "struct") != NULL)
				{
					struct_union = true;
					struct_counter++;
					//while(strstr(obuf, key.c_str()) == NULL)
					while(strcmp(trim(obuf), key.c_str()) != 0)
					{
						fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);
					//	printf("obuf: %s\n",obuf);	
					}
				}
				else
				{
					union_counter++;
					struct_union = false;
				}
				//Make a vector of all fields
				while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
				{
					char * decl;
					char * name;
					char * type;
					int offset;
					int size;
					char * ptr;
					field_t fld;
					string strfinaltype;

					fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
				//	printf("field buffer: %s\n",buffer);
					
					trim(buffer);

					//printf("buffer=[%s]\n", buffer);
					//printf("obuf=[%s]\n", obuf);

					if((strcmp(trim(buffer),"};") == 0) || (strstr(buffer,ATTR_STRING) != NULL))
						break;
					
					decl = get_field_info(buffer,1);
					assert(strcmp(decl,"field") == 0);
					type = get_field_info(buffer,2);

					if(is_typedef(type))
					{
						const char * resolved_type;
						const char * ptr;
						string final_type;

						//cout << "Resolving type " << type << endl;

						ptr = strtok(type," ");
						resolved_type = resolve_typedef(ptr);

						if(strcmp(resolved_type,"") == 0)
						{
							final_type = type;
						}
						else
						{
							final_type = resolved_type;
							ptr = strtok(NULL," ");

							if(ptr != NULL)
							{
								final_type = final_type + ptr;
							}
						}

						strfinaltype = final_type;	
						//cout << "Resolved to " << final_type << endl;
						
					}
					else
					{
						strfinaltype = type;
					}

					name = get_field_info(buffer,3);
					
					fld.name = name;
					//fld.type = type;	
					fld.type = strfinaltype;

					if(struct_union == true)
					{
						fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);

						ptr = strtok(obuf," ");

						//printf("obuf=%s\n", obuf);
						//printf("name=%s ptr=%s\n", name,ptr);
						//Assert is commented because there is some naming discrepancy between typedefs.gen and offsets.gen.fixed
						//assert(strcmp(name,ptr) == 0);	

						ptr = strtok(NULL," ");

						offset = atoi(ptr);

						ptr = strtok(NULL," ");

						size = atoi(ptr);
						
						fld.size = size;
						fld.offset = offset;
					}
					else
					{
						fld.size = -1;
                       		fld.offset = -1;
					}

					vfields.push_back(fld);
				}
				def_map.insert(make_pair(key,vfields));
			}
		}

		fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
	}
	typedefs.clear();
	
	cout << "Total number of definitions = " << total_defs_counter << endl;
	cout << "Struct definitions # = " << struct_counter << endl;
	cout << "Union definitions # = " << union_counter << endl;
}

void build_typedef_index()
{
	FILE * fdtypes;
	char buffer[MAX_LINE_INPUT_SIZE];
    int arr_index = 0;
                                                                                                                                               
    fdtypes = fopen("input/typedefs.gen","r");
    if(fdtypes == NULL)
    {
        printf("Cannot open file input/typedefs.gen\n");
        exit(-1);
    }

	fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
 	while(!feof(fdtypes))
    {
        char * decl;
        char * name;
        char * type;
                                                                                                                                               
        decl = get_field_info(buffer,1);
        name = get_field_info(buffer,2);
        type = get_field_info(buffer,3);
                                                                                                                                               
                                                                                                                                               
        if((decl != NULL) && (name != NULL) && (type != NULL))
        {
            if(strcmp(decl,"typedef") == 0)
            {
				typedefs.insert(make_pair(name,type));	
            }
        }
        fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
    }
	fclose(fdtypes);
}

bool is_typedef(const char * str)
{
	if(strstr(str,"int") != NULL)
	{
		return false;
	}
	else if(strstr(str,"long") != NULL)
	{
		return false;
	}
	else if(strstr(str,"short") != NULL)
	{
		return false;
	}
	else if(strstr(str,"void") != NULL)
	{
		return false;
	}
	else if(strstr(str,"double") != NULL)
	{
		return false;
	}
	else if(strstr(str,"void") != NULL)
	{
		return false;
	}
	else if(strstr(str,"char") != NULL)
	{
		return false;
	}
	else if(strstr(str,"struct") != NULL)
	{
		return false;
	}
	else if(strstr(str,"union") != NULL)
	{
		return false;
	}
	else if(strstr(str,"enum") != NULL)
	{
		return false;
	}
	else
	{
		return true;
	}
}


/* Returns the resolved type of the given typedef statement, else returns NULL */
const char * resolve_typedef(const char * str)
{
	string s = str;	
	string value = "";

	map<string,string>::iterator iter = typedefs.find(s);
	
	while(iter != typedefs.end())
  	{
		value = iter->second;
		if(is_typedef(value.c_str()))
		{
			iter = typedefs.find(value);
		}
		else
		{
			break;
		}

  	}
	return(value.c_str());	
}

