#!/usr/bin/perl -w
use strict;

my $header = "temp/types.h";
my @graph;
my %hTmp;
my $block;
my $count = 0;
my $countname = 0;
my @anonstack;

open (IN, "<$header") or die "Couldn't open input file: $!";

sub handleenum{
	$count++;

	my $sLine = $_[0];
	
	if(substr($sLine,-2,1) eq ";"){
			
		my $i = 0;
		while(substr($sLine,$i,1) ne "}"){
			$i++;
		}

		my $name = substr($sLine,$i+2,(length $sLine)-$i-4);
		my $anonenum = "__anonenum_" . "$name" . "_" . $count;
		my $block = substr($sLine,9,$i-8);
		my $anonfield = "\tenum " . $anonenum . " " . $name . ";\n";
		push(@{$_[1]},$anonfield);

		print STDOUT "enum " . $anonenum . " " . $block . ";\n";

	}
	else {
		my $block = substr($sLine,9,length $sLine);

		while($sLine = <IN>){
			if(substr($sLine,-2,1) eq ";"){
	
				my $i = 0;
				while(substr($sLine,$i,1) ne "}"){
					$i++;
				}

				my $name = substr($sLine,$i+2,(length $sLine)-$i-4);
				my $anonenum = "__anonenum_" . "$name" . "_" . $count;
				$block = $block . substr($sLine,0,$i+1);				
				my $anonfield = "\tenum " . $anonenum . " " . $name . ";\n";
				push(@{$_[1]},$anonfield);
				print STDOUT "enum " . $anonenum . " " . $block . ";\n";

				last;
			}
			else{
				$block = $block . $sLine;
			}
		}
	}
}

sub anonomize{
	$count++;
	my @stack;
	my $type = $_[0];

	while (my $sLine = <IN>){
		my @values = split(" ",$sLine);

		if($values[0] eq "struct" && $values[1] eq "{"){
			anonomize("struct",\@stack);
		}
		elsif($values[0] eq "union" && $values[1] eq "{"){
			anonomize("union",\@stack);
		}
		elsif($values[0] eq "}"){
			my $name = $values[1];
			chop $name;

			my $anonfield = "\t" . $type . " " . " __anon" . $type . 
					   "_" . $name . "_" . $count . " " . $name . ";\n";

			push(@{$_[1]},$anonfield);
			print STDOUT $type . " " . "__anon" . $type .
					   "_" . $name . "_" . $count . " {\n";

			push (@stack,"};\n");
			last;
		}
		elsif($values[0] eq "};"){
			$countname++;
			#print STDOUT "noname\n";
			my $anonfield = "\t" . $type . " " . " __anon" . $type . 
					   "__missing_field_name_" . $count . " " . "annonCompField" . $countname . ";\n";
			push(@{$_[1]},$anonfield);
			
			print STDOUT $type . " " . " __anon" . $type . 
					   "__missing_field_name_" . $count . " {\n";

			push (@stack,"};\n");
			last;
		}
		else{
			push(@stack, $sLine);
		}
	}
	
	while($#stack > -1){
		print STDOUT shift(@stack);
	}
}

while (my $sLine = <IN>) {

	if(substr($sLine,0,6) eq "struct"){

		if(substr($sLine,(length $sLine)-2,1) eq ";"){
			print STDOUT $sLine;
		}
		else{
			my @stack;
	
			#my $structname = $sLine;
			push(@stack, $sLine);
	
			while ($sLine = <IN>){
	
				my @values = split(" ",$sLine);
				
				if($values[0] eq "struct" && $values[1] eq "{"){
					anonomize("struct",\@stack);
				}
				elsif($values[0] eq "union" && $values[1] eq "{"){
					anonomize("union",\@stack);
				}
				elsif($values[0] eq "enum" && substr($values[1],0,1) eq "{"){
					handleenum($sLine,\@stack);
				}
				elsif(substr($sLine,0,2) eq "};"){
					push(@stack, $sLine);
					last;
				}
				else{
					push(@stack, $sLine);
				}
			}
	
			while($#stack > -1){
				print STDOUT shift(@stack);
			}
		}
	}
	elsif(substr($sLine,0,5) eq "union"){

		if(substr($sLine,(length $sLine)-2,1) eq ";"){
			print STDOUT $sLine;
		}
		else{
			my @stack;
	
			#my $structname = $sLine;
			push(@stack, $sLine);
	
			while ($sLine = <IN>){
	
				my @values = split(" ",$sLine);
				
				if($values[0] eq "struct" && $values[1] eq "{"){
					anonomize("struct",\@stack);
				}
				elsif($values[0] eq "union" && $values[1] eq "{"){
					anonomize("union",\@stack);
				}
				elsif($values[0] eq "enum" && substr($values[1],0,1) eq "{"){
					handleenum($sLine,\@stack);
				}
				elsif(substr($sLine,0,2) eq "};"){
					push(@stack, $sLine);
					last;
				}
				else{
					push(@stack, $sLine);
				}
			}
	
			while($#stack > -1){
				print STDOUT shift(@stack);
			}
		}
	}
	elsif(substr($sLine,0,16) eq "typedef struct {"){
		$count++;
		
		my @stack;
		
		while ($sLine = <IN>){

			my @values = split(" ",$sLine);
			
			if($values[0] eq "struct" && $values[1] eq "{"){
				anonomize("struct",\@stack);	
			}
			elsif($values[0] eq "union" && $values[1] eq "{"){
				anonomize("union",\@stack);
			}
			elsif($values[0] eq "enum" && substr($values[1],0,1) eq "{"){
				handleenum($sLine,\@stack);
			}
			elsif(substr($sLine,0,1) eq "}" && substr($sLine,-2,1) eq ";"){
				my $name = substr($sLine,2,(length $sLine) - 4);
				my $anonstruct = "__anonstruct_" . "$name" . "_" . $count;
				
				print STDOUT "struct " . $anonstruct . " {\n";
				while($#stack > -1){
					print STDOUT shift(@stack);
				}
				print STDOUT "};\n";
				print STDOUT "typedef struct " . $anonstruct . " " . $name . ";\n";  
						
				last;
			}
			else{
				push(@stack,$sLine);
			}
		}
	}
	elsif(substr($sLine,0,15) eq "typedef union {"){
		$count++;
		
		my @stack;
		
		while ($sLine = <IN>){
			
			my @values = split(" ",$sLine);
			
			if($values[0] eq "struct" && $values[1] eq "{"){
				anonomize("struct",\@stack);	
			}
			elsif($values[0] eq "union" && $values[1] eq "{"){
				anonomize("union",\@stack);
			}
			elsif($values[0] eq "enum" && substr($values[1],0,1) eq "{"){
				handleenum($sLine,\@stack);
			}
			elsif(substr($sLine,0,1) eq "}" && substr($sLine,-2,1) eq ";"){
				my $name = substr($sLine,2,(length $sLine) - 4);
				my $anonunion = "__anonunion_" . "$name" . "_" . $count;
				
				print STDOUT "union " . $anonunion . " {\n";
				while($#stack > -1){
					print STDOUT shift(@stack);
				}
				print STDOUT "};\n";
				print STDOUT "typedef union " . $anonunion . " " . $name . ";\n";  
						
				last;
			}
			else{
				push(@stack,$sLine);
			}
		}
	}
	elsif(substr($sLine,0,14) eq "typedef enum {"){
		$count++;	
	
		if(substr($sLine,-2,1) eq ";"){
			
			my $i = 0;
			while(substr($sLine,$i,1) ne "}"){
				$i++;
			}

			my $name = substr($sLine,$i+1,(length $sLine)-$i-3);
			my $anonenum = "__anonenum_" . "$name" . "_" . $count;
			my $block = substr($sLine,13,(length $sLine)-14 - ((length $sLine)-$i-2));
			print STDOUT "enum " . $anonenum . " " . $block . ";\n";
			print STDOUT "typedef enum " . $anonenum . " " . $name . ";\n";  
		}
		else{
			my @stack;
			
			push(@stack,substr($sLine,13,(length $sLine)-13));
		
			while ($sLine = <IN>){

				if(substr($sLine,-2,1) eq ";"){

					my $i = 0;
					while(substr($sLine,$i,1) ne "}"){
						$i++;
					}

					my $name = substr($sLine,$i+1,(length $sLine)-$i-3);
					my $anonenum = "__anonenum_" . "$name" . "_" . $count;
					
					print STDOUT "enum " . $anonenum . " ";
					while($#stack > -1){
						print STDOUT shift(@stack);
					}
					
					$i = 0;
					while(substr($sLine,$i,1) ne "}"){
						$i++;
					}
	
					print STDOUT substr($sLine,0,$i+1) . ";\n";

					print STDOUT "typedef enum " . $anonenum . " " . $name . ";\n";  
							
					last;
				}
				else{
					push(@stack,$sLine);
				}
			}
		}
	}
	else{
		print STDOUT $sLine;
	}

}

close(IN);
