#!/usr/bin/perl -w
use strict;

my $origfile = "temp/names.txt";
my $outfile = "temp/gdbscript.txt";
my %hTmp;
my $block;
my $ptype;
my @values;

open (IN, "<$origfile") or die "Couldn't open input file: $!";
open (OUT, ">$outfile") or die "Couldn't open output file: $!";

while (my $sLine = <IN>) {
 
	$block = $sLine;
	
	#print STDOUT "in first while\n";

	if($sLine eq "\n"){
		next;
	}

	if(substr($sLine,0,8) eq "\@typedef"){
		#print STDOUT "typedef found\n"; 
		
		@values = split(' |@', $sLine);

		chop $values[3];

		$ptype = "ptype $values[3] \n";

		#print $ptype;

		print OUT qq{$ptype} unless ($hTmp{$ptype}++);
		next;
	}

	if(substr($sLine,0,6) eq "struct"){
		#print STDOUT "typedef found\n"; 

		@values = split(' ', $sLine);
  
    		$ptype = "ptype $values[0] $values[1] \n";
		
	#	print $ptype;

		print OUT qq{$ptype} unless ($hTmp{$ptype}++);
		next;
	}

	if(substr($sLine,0,5) eq "union"){
		@values = split(' ', $sLine);
  
    		$ptype = "ptype $values[0] $values[1] \n";
		
		#print $ptype;

		print OUT qq{$ptype} unless ($hTmp{$ptype}++);
		next;
	}
	
	if(substr($sLine,0,4) eq "enum"){
		@values = split(' ', $sLine);
  
    		$ptype = "ptype $values[0] $values[1] \n";
		
		#print $ptype;

		print OUT qq{$ptype} unless ($hTmp{$ptype}++);
		next;
	}

}
 
close OUT;
close IN;
