#!/usr/bin/perl -w
use strict;

my $gdbscript = "temp/gdbscript.txt";
my $structs = "temp/structoutput.txt";
my $outfile = "temp/structwithname.txt";
my $block;
my %gdbname;
my $enum = 0;
my $union = 0;
my $struct = 0;
my $typedef = 0;
my $error = 0;

open (GDB, "<$gdbscript") or die "Couldn't open input file: $!";
open (STRUCTS, "<$structs") or die "Couldn't open input file: $!";
open (OUT, ">$outfile") or die "Couldn't open output file: $!";


while (my $sLine = <STRUCTS>) {

	my $sLine2 = <GDB>;
	
	$block = $sLine;

	if(substr($sLine,0,4) eq "type"){

		if(substr($sLine,7,4) eq "enum"){
			if(substr($sLine2,6,4) eq "enum"){
			
				$enum = $enum + 1;
	
				if(substr($sLine,(length $sLine)-2,1) eq "}" || substr($sLine,(length $sLine)-2,1) eq ")"){
					chomp $block;
					$block = $block . ";\n";
	
					#print STDOUT $sLine2;
					print STDOUT substr($block,7,length($block)-7);
					next;
				}
				else{
					while($sLine = <STRUCTS>){
						
						$block = $block . $sLine;
	
						if(substr($sLine,(length $sLine)-2,1) eq "}" || substr($sLine,(length $sLine)-2,1) eq ")"){			
							chomp $block;
							$block = $block . ";\n";
		
							#print STDOUT $sLine2;
							print STDOUT substr($block,7,length($block)-7);
							last;
						}
					}
				}
			}
			else{
				
				$typedef = $typedef + 1;
				#print STDOUT $sLine2;

				if(substr($sLine,(length $sLine)-2,1) eq "}" || substr($sLine,(length $sLine)-2,1) eq ")"){
					
					if(substr($sLine,(length $sLine)-2,1) eq ")"){
						my $name = substr($sLine2,6,length($sLine2)-8);
						chomp $name;
						my $type = substr($block,7,length($block)-8);

						my @values = split(" ",$type);

						print STDOUT "typedef enum ";
						print STDOUT $values[1]. " ";
						print STDOUT "(" . $name . ")";
						print STDOUT $values[$#values-2] . " ";
						print STDOUT $values[$#values-1] . " ";
						print STDOUT $values[$#values];
						print STDOUT ";\n";
					}
					else{
						my $name = substr($sLine2,6,length($sLine2)-8);
						chomp $name;
						my $type = substr($block,7,length($block)-8);

						print "typedef ";
						print $type;
						print $name;
						print STDOUT ";\n";
					}

				
					next;
				}
				else{
					while($sLine = <STRUCTS>){
						
						$block = $block . $sLine;
	
						if(substr($sLine,(length $sLine)-2,1) eq "}" || substr($sLine,(length $sLine)-2,1) eq ")"){

							if(substr($sLine,(length $sLine)-2,1) eq ")"){
								my $name = substr($sLine2,6,length($sLine2)-8);
								chomp $name;
								my $type = substr($block,7,length($block)-8);
	
								my @values = split(" ",$type);
			
								#print STDOUT $sLine2;

								print STDOUT "typedef enum ";
								print STDOUT $values[1]. " ";
								print STDOUT "(" . $name . ")";
								print STDOUT $values[$#values-2] . " ";
								print STDOUT $values[$#values-1] . " ";
								print STDOUT $values[$#values];
								print STDOUT ";\n";
							}
							else{
								my $name = substr($sLine2,6,length($sLine2)-8);
								chomp $name;
								my $type = substr($block,7,length($block)-8);
	
								#print STDOUT $sLine2;

								print STDOUT "typedef ";
								print STDOUT $type;
								print STDOUT $name;
								print STDOUT ";\n";
							}
							last;
						}
					}
				}
			}
		}
		elsif(substr($sLine,7,6) eq "struct"){

			if(substr($sLine2,6,6) eq "struct"){

				$struct = $struct + 1;
	
				while($sLine = <STRUCTS>){
					
					if (substr($sLine,0,1) eq "}"){
	
						$sLine = "};\n";
					}
			
					$block = $block . $sLine;
	
					if (substr($sLine,0,1) eq "}"){
						#print STDOUT $sLine2;
						print STDOUT substr($block,7,length($block)-7);
				
						last;
					}
				}
			}
			else{
				$typedef = $typedef + 1;
	
				#print STDOUT $sLine2;

				my $name = substr($sLine2,6,length($sLine2)-8);
				chomp $name;
				my $type = substr($block,7,length($block)-9);

				print STDOUT "typedef ";
				if(length $type > 7){
					print STDOUT $type;
					print STDOUT $name;
					print STDOUT ";\n";
				}
	
				while($sLine = <STRUCTS>){
					
					if (substr($sLine,0,1) eq "}"){
	
						$sLine = "} " . $name . ";\n";
					}
			
					$block = $block . $sLine;
	
					if (substr($sLine,0,1) eq "}"){
						
						if(length $type == 7){
							print STDOUT substr($block,7,length($block)-7);
							#print "\n";
						}
				
						last;
					}
				}
			}
			
		}
		elsif(substr($sLine,7,5) eq "union"){
			#print STDOUT "union found\n";
			if(substr($sLine2,6,5) eq "union"){
				$union = $union + 1; 
			
				#print STDOUT $sLine2;
		
				while($sLine = <STRUCTS>){
		
					if (substr($sLine,0,1) eq "}"){
						$sLine = "};\n";
					}
			
					$block = $block . $sLine;
		
					if (substr($sLine,0,1) eq "}"){
						print STDOUT substr($block,7,length($block)-7);
				
						last;
					}
				}
			}
			else{
				
				#print STDOUT $sLine2;
			
				my $name = substr($sLine2,6,length($sLine2)-8);
				chomp $name;
				my $type = substr($block,7,length($block)-10);

				#if($sLine2 eq "ptype pte_t \n"){
			#		print STDOUT "YES ";
			#		print length $type;
			#		print $type;
			#		print "\n";
			#	}

				#print STDOUT "YES type : ";
				#print STDOUT $type;
				#print STDOUT " length: ";
				#print STDOUT length $type;
				#print STDOUT "\n";

				print STDOUT "typedef ";

				if(length $type > 5){
					print STDOUT $type;
					print STDOUT " ";
					print STDOUT $name;
					print STDOUT ";\n";
				}

				
				while($sLine = <STRUCTS>){
		
					if (substr($sLine,0,1) eq "}"){
						$sLine = "} " . $name . ";\n";
					}
			
					$block = $block . $sLine;
		
					if (substr($sLine,0,1) eq "}"){

						if(length $type == 5){
							print STDOUT substr($block,7,length($block)-7);
							#print "\n";
						}
				
						last;
					}
				}

			}

		}
		else {
			$typedef = $typedef + 1;
			#print STDOUT "normal found\n"; 

			if((substr($sLine,7,3) eq "int" || substr($sLine,7,4) eq "void" || substr($sLine,7,14) eq "unsigned int (") && (length $sLine) > 11){
				
				#print STDOUT $sLine2;

				if(substr($sLine,(length $sLine)-2,1) eq ")"){
		
						my $type = substr($block,7,length($block)-6);
						chomp $type;
						my $name = substr($sLine2,6,length($sLine2)-7);
						chomp $name;
						
						print STDOUT "typedef ";
						if(substr($type,0,3) eq "int"){
							print STDOUT "int ";
							$type = substr($type,3,length($block)-3);

							if(substr($type,1,3) eq "(*)"){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,4,length($block)-3);
							}
							elsif(substr($type,1,2) eq "*)" ){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,3,length($block)-2);
							}
							elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
							}
							else {
								print $name;
							}
						}
						if(substr($type,0,4) eq "void"){
							print STDOUT "void ";
							$type = substr($type,4,length($block)-4);

							if(substr($type,1,3) eq "(*)"){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,4,length($block)-3);
							}
							elsif(substr($type,1,2) eq "*)" ){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,3,length($block)-2);
							}
							elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
							}
							else {
								print $name;
							}
						}
						if(substr($type,0,8) eq "unsigned"){
							print STDOUT "unsigned int ";
							$type = substr($type,12,length($block)-12);

							if(substr($type,1,3) eq "(*)"){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,4,length($block)-3);
							}
							elsif(substr($type,1,2) eq "*)" ){
								print STDOUT "(* ";
								print $name;
								print STDOUT ") ";
							
								$type = substr($type,3,length($block)-2);
							}
							elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
							}
							else {
								print $name;
							}
						}

						print $type;
						print ";\n";
							
						next;
				}
				else {
					while($sLine = <STRUCTS>){
					
						$block = $block . $sLine;
				
						if(substr($sLine,(length $sLine)-2,1) eq ")"){


							my $type = substr($block,7,length($block)-6);
							chomp $type;
							my $name = substr($sLine2,6,length($sLine2)-7);
							chomp $name;
							
							print STDOUT "typedef ";
							if(substr($type,0,3) eq "int"){
								print STDOUT "int ";
								$type = substr($type,3,length($block)-3);

								if(substr($type,1,3) eq "(*)"){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,4,length($block)-3);
								}
								elsif(substr($type,1,2) eq "*)" ){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,3,length($block)-2);
								}
								elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
								}
								else {
									print $name;
								}
							}
							if(substr($type,0,4) eq "void"){
								print STDOUT "void ";
								$type = substr($type,4,length($block)-4);

								if(substr($type,1,3) eq "(*)"){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,4,length($block)-3);
								}
								elsif(substr($type,1,2) eq "*)" ){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,3,length($block)-2);
								}
								elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
								}
								else {
									print $name;
								}
							}
							if(substr($type,0,8) eq "unsigned"){
								print STDOUT "unsigned int ";
								$type = substr($type,12,length($block)-12);

								if(substr($type,1,3) eq "(*)"){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,4,length($block)-3);
								}
								elsif(substr($type,1,2) eq "*)" ){
									print STDOUT "(* ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,3,length($block)-2);
								}
								elsif(substr($type,1,1) eq "*" ){
									print STDOUT "*( ";
									print $name;
									print STDOUT ") ";
								
									$type = substr($type,2,length($block)-1);
								}
								else {
									print $name;
								}
							}
	
							print $type;
							print ";\n";
							
							last;
						}
					}
				}
			
			}
			else{
				#print STDOUT $sLine2;
				
				my $type = substr($block,7,length($block)-6);
				chomp $type;
				my $name = substr($sLine2,6,length($sLine2)-7);
				chomp $name;
				
				print STDOUT "typedef ";
				print $type;
				print " ";
				print $name;
				print ";\n";
			}
		}		

		#print "\n";
		next;
	}
	elsif(substr($sLine,0,10) eq "/home/jeff"){
		#print STDOUT "error found\n"; 
		$error = $error + 1; 

		$sLine = <STRUCTS>;
		$block = $block . $sLine;

	#	print STDOUT $sLine2;
	#	print STDOUT $block;
	#	print "\n";
	}
}

#print "enum: ";
#print $enum;
#print " union: ";
#print $union;
#print " struct: ";
#print $struct;
#print " typedefs: ";
#print $typedef;
#print " errors: ";
#print $error;
#print "\n";

close GDB;
close STRUCTS; 
close OUT;

