#include <stdio.h>
#include <assert.h>
//#include "../input/typedefs.txt.h"

/* Generator - generates a C program that prints offets of composite 
	data structure members.
	Reads from file input/typedefs.gen
	Declares a member of type struct for each new struct
		- For non-pointer members, prints offset
		- For pointer to structs, declares struct of pointed type
	Prints results in file input/typeoffsets.gen 
*/ 
#define MAX_LINE_INPUT_SIZE 500
#define MAX_FIELD_WIDTH 300
#define LEFT_FIELD_DELIMITER  '@'
#define RIGHT_FIELD_DELIMITER '|'

#define ATTR_STRING "} __attribute__(("
#define BASE_NAME "foo"

char * get_field_info(char * buffer, short field_num);
char * ltrim(char * str);
char * rtrim(char * str);
char * trim(char * str);

int COUNTER =0;

int main()
{
	FILE * fd_code;
	FILE * fd_in;
	char buffer[MAX_LINE_INPUT_SIZE];

	fd_code = fopen("print_offsets_gen.c","w");
	if(fd_code == NULL)
	{
		printf("Cannot create file print_offsets.c\n");
		exit(-1);
	}

	fd_in = fopen("../input/typedefs.gen","r");	
	if(fd_in == NULL)
	{
		printf("Cannot open input file input/typedefs.txt\n");
		exit(-1);
	}
	
	fprintf(fd_code,"#include <stdio.h>\n");
	fprintf(fd_code,"#include \"typedefs.txt.h\"\n\n\n");
	fprintf(fd_code,"int main()\n");
	fprintf(fd_code,"{\n");
	fprintf(fd_code,"\tFILE * fd_out;\n\n");
	fprintf(fd_code,"\tfd_out = fopen(\"../input/offsets.txt\",\"w\");\n\n");
	fprintf(fd_code,"\tif (fd_out == NULL)\n");
	fprintf(fd_code,"\t{\n");
	fprintf(fd_code,"\t\tprintf(\"Cannot open file ../input/offsets.gen\\n\");\n");
	fprintf(fd_code,"\t\texit(-1);\n");
	fprintf(fd_code,"\t}\n");
	
	fgets(buffer,MAX_LINE_INPUT_SIZE, fd_in);	

	while(!feof(fd_in))
	{
		//Only consider structs and print their offsets
		//May require to also consider unions later
		//printf("buffer=%s\n", buffer);
		if((strstr(buffer,"struct") != NULL) && (buffer[strlen(trim(buffer)) -1] == '{'))
		{
			char varname[MAX_FIELD_WIDTH];
			char strbuffer[MAX_FIELD_WIDTH];
			char * ptr;
			char temp[MAX_FIELD_WIDTH];

			strcpy(strbuffer, buffer);
			ptr = strtok(strbuffer," ");
			ptr = strtok(NULL, " ");

			sprintf(varname,"%s_%d", BASE_NAME,COUNTER++);

			//Declare a struct variable of type current struct
			fprintf(fd_code,"\tstruct %s %s;\n", ptr, varname);		

			sprintf(temp,"\tfprintf(fd_out, \"struct %s \\n\");\n",ptr);
			fprintf(fd_code,"%s", temp);

			fgets(buffer,MAX_LINE_INPUT_SIZE, fd_in);

			if((strcmp(trim(buffer),"};") == 0) || (strcmp(trim(buffer),ATTR_STRING) == 0)) 
			{
				//Empty struct - can skip this one
				fgets(buffer,MAX_LINE_INPUT_SIZE, fd_in);	
				continue;	
			}
				
			while((strstr(buffer,"};") == NULL) && (strstr(buffer,ATTR_STRING) == NULL))
			{
				char * literal;
				char * name;
				char * type;

				
				literal = get_field_info(buffer,1);
            	type = get_field_info(buffer,2);
            	name = get_field_info(buffer,3);
	
				assert(strcmp(literal,"field") ==0);

				//Make the generated code print offsets to a file
				//sprintf(temp,"((%s)&%s.%s - (%s)&%s)","unsigned int",varname,name, "unsigned int", varname);
				sprintf(temp,"((%s)&%s.%s - (%s)&%s), sizeof(%s.%s)","unsigned int",varname,name, "unsigned int", varname, varname,name);
				//fprintf(fd_code,"fprintf(fd_out,\"\      %s %s \\n\",%s);\n", name,"%d",temp);		
				fprintf(fd_code,"fprintf(fd_out,\"\      %s %s %s\\n\",%s);\n", name,"%d","%d",temp);		

				fgets(buffer,MAX_LINE_INPUT_SIZE, fd_in);
			}
		}

		
		fgets(buffer,MAX_LINE_INPUT_SIZE, fd_in);	
	}	

	fprintf(fd_code,"\tfclose(fd_out);\n");
	fprintf(fd_code,"\treturn 0;\n");
	fprintf(fd_code,"}\n");
	
	fclose(fd_code);
	fclose(fd_in);
	
	return 0;
}

char * get_field_info(char * buffer, short field_num)
{
    char l_delimiter =LEFT_FIELD_DELIMITER;
    char r_delimiter =RIGHT_FIELD_DELIMITER;
    short field_counter =0;
    char * ret_buf;
    short start_copying = 0, copied =0;
    int j=0;
    int i;
                                                                                                                                               
    ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
    for(i=0; i< strlen(buffer); i++)
    {
        if(buffer[i] == l_delimiter)
        {
            field_counter++;
            if(field_counter == field_num) //This is the field to return
            {
                start_copying = 1;
            }
        }
        else if(buffer[i] == r_delimiter)
        {
            if(field_counter == field_num)
            {
                assert(start_copying == 1);
                *(ret_buf + j) = '\0';
                copied = 1;
                break;
            }
        }
        else
        {
            if(start_copying == 1)
            {
                *(char *)(ret_buf + j) = buffer[i];
                                                                                                                                               
                j++;
            }
        }
    }
    if(copied == 1)
        return(ret_buf);
    else
        return(NULL);
}

char * rtrim(char * str)
{
    int i;
                                                                                                                                               
                                                                                                                                               
    for(i = (strlen(str) - 1); i >= 0; i--)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
                                                                                                                                               
        if((c == ' ') || (c == '\0') || (c == '\n'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                                                                                               
                                                                                                                                               
char * ltrim(char * str)
{
    int i;
                                                                                                                                               
                                                                                                                                               
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
                                                                                                                                               
        if((c == ' ') || (c == '\0'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}

char * trim(char * str)
{
    return(rtrim(ltrim(str)));
}


