#!/usr/bin/perl -w
use strict;

my $origfile = "typedefs.txt";
my $outfile = "typedefs.txt_linked";

open (IN, "<$origfile") or die "Couldn't open input file: $!";
open (OUT, ">$outfile") or die "Couldn't open output file: $!";

my $curr_struct;

while (my $sLine = <IN>) {
 
	if(substr($sLine,0,6) eq "struct"){
		my @field = split(" ",$sLine);
		
		$curr_struct = $field[1];
		
		print STDOUT $curr_struct . "\n"; 
		
		print OUT $sLine;	

		next;
	}

	if(substr($sLine,0,31) eq "     \@field| \@struct list_head|") {
		print STDOUT $sLine;
		my @field = split(" ",$sLine);
		my $field_name = substr($field[$#field],1,-2);

		print STDOUT $field_name . "\n";
		print OUT "     \@field| \@struct list_head __attribute__((__container__(sizeof(struct " 
		              . $curr_struct . "___" . $field_name . " *)))) | @" . $field_name . "|;\n";
		next;
	}

	print OUT $sLine;
}
 
close OUT;
close IN;
