/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/**
   @file gm_log2.c
   This file contains the GM API functions related to base 2
   logarithmic computations.
 
   gm_log2_roundup_table(), gm_log2_roundup().
*/


const unsigned char
gm_log2_roundup_table[257] = {
  0,
  0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
};

/**
   gm_log2_roundup() returns the logarithm, base 2, of \b n, rounding
   up to the next integer.
 
   @retval LOG
 
   @param n \b (IN) The integer for which the logarithm will be computed.
 
   @author Glenn Brown
 
   @version GM_API_VERSION (as defined in gm.h)
 
*/

unsigned long
gm_log2_roundup (unsigned long n)
{
  unsigned ret;

  if (n <= 0x100)
    ret = gm_log2_roundup_table[n] + 0;
  else
    {
      n = (n+0xff)>>8 & 0xffffff;
      if (n <= 0x100)
	ret = gm_log2_roundup_table[n] + 8;
      else
	{
	  n = (n+0xff)>>8;
	  if (n <= 0x100)
	    ret = gm_log2_roundup_table[n] + 16;
	  else
	    {
	      n = (n+0xff)>>8;
	      ret = gm_log2_roundup_table[n] + 24;
	    }
	}
    }
  return ret;
}
