#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <sys/resource.h>

#include <xenctrl.h>
#include <xenaccess/xenaccess.h>

#include "xg_save_restore.h"
#include "xg_private.h"

#define BITS_PER_LONG (sizeof(unsigned long) * 8)
#define BITS_TO_LONGS(bits) (((bits)+BITS_PER_LONG-1)/BITS_PER_LONG)
#define BITMAP_SIZE   (BITS_TO_LONGS(p2m_size) * sizeof(unsigned long))

#define BITMAP_ENTRY(_nr,_bmap) \
   ((volatile unsigned long *)(_bmap))[(_nr)/BITS_PER_LONG]

#define BITMAP_SHIFT(_nr) ((_nr) % BITS_PER_LONG)

static inline int test_bit (int nr, volatile void * addr)
{
    return (BITMAP_ENTRY(nr, addr) >> BITMAP_SHIFT(nr)) & 1;
}

void *xg_memalign(size_t alignment, size_t size)
{
#if defined(_POSIX_C_SOURCE) && !defined(__sun__)
    int ret;
    void *ptr;
    ret = posix_memalign(&ptr, alignment, size);
    if (ret != 0)
        return NULL;
    return ptr;
#elif defined(__NetBSD__) || defined(__OpenBSD__)
    return valloc(size);
#else
    return memalign(alignment, size);
#endif
}

int main(int argc, char **argv)
{
	int xc_handle, frc;
	xc_dominfo_t info;
	uint32_t dom;
	unsigned long p2m_size;
	xc_shadow_op_stats_t stats;
	unsigned long *to_send = NULL;

	/* The new domain's shared-info frame number. */
	unsigned long shared_info_frame;

	/* Live mapping of shared info structure */
	shared_info_any_t *live_shinfo = NULL;

	if(argc == 1)
	{
		printf("USAGE ./mapall <dom_id>\n");
		exit(-1);	
	}

	dom = atoi(argv[1]);
	//address = atoi(argv[2]);
	
	printf("domain: %d\n",dom);

	xc_handle = xc_interface_open();
	
	if(xc_handle == -1)
	{
		fprintf(stderr, "Unable to get handle to hypervisor\n");
		exit(-1);
	}

	p2m_size = xc_memory_op(xc_handle, XENMEM_maximum_gpfn, &dom) + 1;


	/* Live suspend. Enable log-dirty mode. */
	if ( xc_shadow_control(xc_handle, dom,
						XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
						NULL, 0, NULL, 0, NULL) < 0 )
	{
		/* log-dirty already enabled? There's no test op,
			so attempt to disable then reenable it */
		frc = xc_shadow_control(xc_handle, dom, XEN_DOMCTL_SHADOW_OP_OFF,
							NULL, 0, NULL, 0, NULL);
		if ( frc >= 0 )
		{
			frc = xc_shadow_control(xc_handle, dom,
								XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
								NULL, 0, NULL, 0, NULL);
		}
		
		if ( frc < 0 )
		{
			ERROR("Couldn't enable shadow mode (rc %d) (errno %d)", frc, errno );
			goto out;
		}
	}


	to_send = xg_memalign(PAGE_SIZE, ROUNDUP(BITMAP_SIZE, PAGE_SHIFT)); 

	if ( !to_send )
	{
		ERROR("Couldn't allocate to_send array");
		goto out;
	}
	
	memset(to_send, 0xff, BITMAP_SIZE);

	for(;;){

		if ( xc_shadow_control(xc_handle, dom, 
					XEN_DOMCTL_SHADOW_OP_CLEAN, to_send, 
					p2m_size, NULL, 0, &stats) != p2m_size )
		{
			ERROR("Error flushing shadow PT");
			goto out;
		}

		sleep(5);
		printf("test %d\n", stats.dirty_count);
	}

	
	/* they use to set all pages as sent initially? */
	//memset(to_send, 0xff, BITMAP_SIZE); 


out:
	free(to_send);
	return 0;
}

