#include "global.h"

extern vector<symbol_t> static_symbol; 
extern multimap<unsigned long long, int> static_symbol_map;
extern int STATIC_SYMBOL_CURRENT;
extern unsigned char dmadata_buffer[SLAB_SIZE];
extern vector<vector <unsigned char> > static_pages;
extern int detection;
extern multimap<unsigned long long, char> learnt_static_invariants;
extern FILE *inv_log;
extern int static_count;
extern int total_checks;
extern map<unsigned long long,int> unique_structs;

#define INV_LOG 1

/*	Reads from the file input/static.memory.map
	Stores information in memory data structures
	Symbol name - memory addr - size
*/
void read_static_map()
{
	FILE * fd_map;
	char buffer[MAX_LINE_INPUT_SIZE];
	fd_map = fopen("input/memory.map.static","r");
	if(fd_map == NULL)
	{
		printf("Cannot find file input/memory.map.static\n");
		exit(-1);
	}
	fgets(buffer,MAX_LINE_INPUT_SIZE,fd_map);

	while(!feof(fd_map))
	{
		symbol_t sym;
		char * straddr, *strtype, *strname, *strsize;

		straddr = get_field_info(buffer, 1);	
		sym.sym_addr = strtoll(straddr,NULL,16);

		strtype = get_field_info(buffer, 2);	
		strcpy(sym.sym_type, strtype);

		strname = get_field_info(buffer, 3);	
		strcpy(sym.sym_name, strname);
	
		strsize = get_field_info(buffer, 4);	
		sym.sym_size = atoi(strsize);
	
		static_symbol.push_back(sym);
		static_symbol_map.insert(make_pair((sym.sym_addr - PAGE_OFFSET) >> 12,static_symbol.size()-1));

		fgets(buffer,MAX_LINE_INPUT_SIZE,fd_map);
	}
}

/* Populates invariant list for static data from previously learnt file */
void populate_from_learnt_file()
{
	FILE * fd;
	char buffer[MAX_LINE_INPUT_SIZE];

	fd = fopen("input/static.invariants","r");
    if(fd == NULL)
    {
        //cout << "Cannot open file input/static.invariants" << endl;
		return;
        //exit(-1);
    }

	fgets(buffer,MAX_LINE_INPUT_SIZE,fd);
	while(!feof(fd))
	{
		char * ptr;
		ptr = strtok(buffer, " ");

		unsigned long long addr = strtoll(ptr,NULL,16);

		learnt_static_invariants.insert(make_pair(addr,1));
		fgets(buffer,MAX_LINE_INPUT_SIZE,fd);
	}
	fclose(fd);
}

/* Saves the data values for static data in memory data structures */
void save_data_values(int page_begin, int msmt_round)
{
	/* Read data from the fetched page and store in the values vector 
		Fetched page available in dmadata_buffer */
		
	/* Get all symbol values from this page */
	int page_end = page_begin + SLAB_SIZE;
//JEFF UNCOMMENT
//	printf("Searching from index=%d\n", STATIC_SYMBOL_CURRENT);
	//printf("page begin=0x%x page end = 0x%x\n", page_begin, page_end);

	for(int i=STATIC_SYMBOL_CURRENT ; i<static_symbol.size(); i++)
	{
		bool value_exists = false;
		int sym_addr = static_symbol[i].sym_addr - PAGE_OFFSET;
//JEFF UNCOMMENT
	//	printf("i=%d , STATIC_SYMBOL_CURRENT =%d static_symbol_size=%d\n", i, STATIC_SYMBOL_CURRENT,static_symbol.size());

#ifdef INV_LOG
			fprintf(inv_log,"[%s] Looking at symbol %s at addr 0x%x page_begin=0x%x page_end=0x%x\n", get_time(),static_symbol[i].sym_name, sym_addr, page_begin, page_end);	
			fflush(inv_log);	
#endif
		static_count++;

		total_checks++;
		unique_structs.insert(make_pair(sym_addr,1));

		assert(sym_addr >= page_begin);	
		if(sym_addr <= page_end)  	
		{
			int offset = sym_addr - page_begin;
			vector<unsigned char> other_values;
			vector<unsigned char> bytes;

			//printf("dmadata_buffer: %s\n",dmadata_buffer);

			for(int k=0; k<static_symbol[i].sym_size; k++)
			{
				//printf("test: %c\n",*(unsigned char *)(dmadata_buffer + offset + k));
				bytes.push_back(*(unsigned char *)(dmadata_buffer + offset + k));
			}

		//	int j;
		//	printf("bytes: ");
		//	for(j=0; j < bytes.size(); j++){
		//		printf("%d ",bytes[j]);
		//	}
		//	printf("\n");

			//Check against existing value
			if(detection == 0)
			{
				if(msmt_round == 1)
				{
					if(learnt_static_invariants.size() == 0)
					{
						populate_from_learnt_file();
						static_symbol[i].invariant = true; 
					}

					if(learnt_static_invariants.size() > 0)
					{
						map<unsigned long long, char>::iterator iter = learnt_static_invariants.find(static_symbol[i].sym_addr);
						if(iter != learnt_static_invariants.end()) 
						{
							static_symbol[i].invariant = true; 
						}
						else
						{
							static_symbol[i].invariant = false; 
						}
						

					}
					
					if(bytes.size() == 0)
						printf("bytes == 0\n");
		
					static_symbol[i].values = bytes;
					static_symbol[i].alert = false; 
					static_symbol[i].reported = false; 
				}
				else
				{	
					if(static_symbol[i].invariant)
					{
						if(static_symbol[i].values != bytes)
						{
							static_symbol[i].invariant = false;
						}
					}
				}
			}
			else
			{
				if(msmt_round == 1)
				{
					if(learnt_static_invariants.size() == 0)
					{
						populate_from_learnt_file();
						static_symbol[i].invariant = true; 
					}

					if(learnt_static_invariants.size() > 0)
					{
						map<unsigned long long, char>::iterator iter = learnt_static_invariants.find(static_symbol[i].sym_addr);
						if(iter != learnt_static_invariants.end())
						{
							static_symbol[i].invariant = true;
						}
						else
						{
							static_symbol[i].invariant = false;
						}
					}
			//		printf("invariant? 0x%llx %s ", static_symbol[i].sym_addr, static_symbol[i].sym_type);	
			//		printf("%s %d", static_symbol[i].sym_name, static_symbol[i].sym_size);	
			//		if(static_symbol[i].invariant == true)
			//			printf(" TRUE\n");
			//		else
			//			printf(" FALSE\n");
					static_symbol[i].values = bytes;
					static_symbol[i].alert = false; 
					static_symbol[i].reported = false; 
				}
				else if((static_symbol[i].invariant) && (!static_symbol[i].reported))
				{
					//printf("static symbol should be invariant\n");
				//	cout << "Checking value of " << static_symbol[i].sym_name << endl;
					int j;
				//	printf("original value: ");
				//	for(j=0; j < static_symbol[i].values.size(); j++){
				//		printf("%d ",static_symbol[i].values[j]);
				//	}
				//	printf("\n");
				//	printf("current value: ");
				//	for(j=0; j < bytes.size(); j++){
				//		printf("%d ",bytes[j]);
				//	}
				//	printf("\n");
					
					//cout << "Old values " << static_symbol[i].values.c_str() << endl;
					//cout << "Current values " << bytes << endl;

					if(static_symbol[i].values != bytes)
					{
						//printf("ALERT - values does not equal bytes\n");
						static_symbol[i].alert = true;
					}
				}
			//	else
					//printf("static symbol not invariant\n");
			}

		}
		else
		{
			STATIC_SYMBOL_CURRENT = i;
			break; //Exhausted all symbols in this page
		}
	}
}

/*void save_and_compare_raw_pages(int page_begin, int msmt_round)
{
	vector<unsigned char> page;
	static FILE * fd_out;
	static int page_num;

	if(msmt_round == 1)
	{
		fd_out = fopen("output/rawmem.txt","a");
		if(fd_out == NULL)
		{
			printf("Cannot create file output/rawmem.txt\n");
			exit(-1);
		}

		for(int k=0;k<SLAB_SIZE; k++)
		{
			page.push_back(*(unsigned char *)(dmadata_buffer + k));		
		}	
		static_pages.push_back(page);
		page_num = 0;
	}
	else
	{
		
		assert(page_num < static_pages.size());
		for(int k=0;k<SLAB_SIZE; k++)
        {
			if(static_pages[page_num][k] != *(unsigned char *)(dmadata_buffer + k))
			{
				fprintf(fd_out, "0x%x\n", (page_begin + k));
			}
		}
		page_num++;
		
		if(page_num == static_pages.size())
		{
			page_num = 0;
		}
	}
} */

                                                                                                                                               
void print_data_values()
{
	FILE * fd_out;
	int i,j;
	
	fd_out = fopen("output/data.values.static","w");

	if(fd_out == NULL)
	{
		printf("Cannot find file output/data.values.static\n");
		exit(-1);
	}

	/*for(i=0; i<static_symbol.size(); i++)
	{
		fprintf(fd_out, "0x%llx %s ", static_symbol[i].sym_addr, static_symbol[i].sym_type);	
		fprintf(fd_out, "%s %d", static_symbol[i].sym_name, static_symbol[i].sym_size);	

		for(j=0; j<static_symbol[i].values.size(); j++)
		{
			switch(static_symbol[i].sym_size)
            {
                //Switch based on primitive data type sizes
                case 1:
				case 2:
				case 4:
						fprintf(fd_out, " %d", static_symbol[i].values[j]);	
						break;
				case 8:
						fprintf(fd_out, " %lld", static_symbol[i].values[j]);	
						break;
				default:
						fprintf(fd_out, " %d", static_symbol[i].values[j]);	
						break;
						
			}
		}
		fprintf(fd_out,"\n");
	} */
	fclose(fd_out);
}

void print_invariants()
{
	FILE * fd_out;
	int i,j;

	fd_out = fopen("output/invariants.static","w");

	if(fd_out == NULL)
	{
		printf("Cannot find file output/invariants.static\n");
		exit(-1);
	}

	for(i=0; i<static_symbol.size(); i++)
    {
		vector<unsigned char> current_val;
			//printf("0x%llx %s size=%d\n",static_symbol[i].sym_addr, static_symbol[i].sym_name, static_symbol[i].values.size());
		assert(static_symbol[i].values.size() > 0);

		current_val = static_symbol[i].values;

		if (static_symbol[i].values.size() > 1)
		{
			//Symbol has more than one distince values
			fprintf(fd_out, "0x%llx %s\n",static_symbol[i].sym_addr, static_symbol[i].sym_name);
		}

		/*
		for(j=0; j<static_symbol[i].values.size(); j++)
        {
			if (!(current_val == static_symbol[i].values[j]))
			
			{	
				fprintf(fd_out, "0x%llx %s\n",static_symbol[i].sym_addr, static_symbol[i].sym_name);
				break;
			}
		} */
	}

	fclose(fd_out);
}

