#!/usr/bin/env perl

#Script used to format output generated by Daikon.
# This is required because objects are split when there are too many records. For example
# Object of type file will appear at program points file0, file1 ... filen. Daikon accordingly 
#displays invariants for those program points. To be understood by the detection engine, these
# split program points have to be merged again. This script does the merging.

my %hash;
my $current;

while (my $line = <>)
{
    chomp $line;
    next if $line =~ /^=+$/;
    next if $line =~ /INV_BEGIN/;
    next if $line =~ /INV_END/;

    if($line =~ /([^:]+):::(.*)/){
        my ($prefix, $suffix) = ($1, $2);
        $prefix =~ s/\d+$//;
        $current = "${prefix}:::${suffix}";
        $hash{$current} = [$current] unless exists $hash{$current};
        next;
    }
    else{
        push @{$hash{$current}}, $line;
    }
}

my @out;
my $prev = "";
local $\ = "\n";
local $, = "\n";
foreach my $key (sort keys %hash){
    my ($prefix, $suffix) = split /:::/, $key;
    if ($prefix ne $prev) {
        print "INV_END\nINV_BEGIN";
        $prev = $prefix;
    }
    print '=' x 75;
    print @{$hash{$key}};
}

print '=' x 75;
print "INV_END"

###Comments Ignore...
#push @out, join "\n", @{$hash{$_}};

#unshift @out, 'INV_BEGIN';
#push @out, 'INV_END';

#local $, = "\n" . ('=' x 20) . "\n";
#local $\ = "\n";
#print @out; 
