#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>
#include <time.h>
#include <sys/time.h>


xa_instance_t xai;

int main (int argc, char **argv)
{
	struct timeval start, end;
				
	gettimeofday(&start, NULL);

	int i=0, j=0, total, total_dirty,total_clean;
	int dirty, xc_handle;	
	uint64_t pte_value;
	unsigned char *memory = NULL;
	unsigned char *memwrite = NULL;
	unsigned char *test = NULL;
	uint32_t offset = 0;
	uint32_t writeoffset = 0;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}
	 xc_handle = xc_interface_open();

	uint32_t cr3 = xai.cr3;
	uint32_t vaddr = 0xc0000000;

	/* GET PDPTE3 VALUE */
	/* page directory pointer table */
	uint32_t pdptb = cr3 & 0xFFFFFFE0;
	uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
	uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
	uint64_t pdpie_value;
	xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);


	/* GET PDE VALUE */
	uint64_t pde_base = pdpie_value & 0xFFFFFF000ULL;
	uint32_t pde_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
	uint32_t pde_entry = pde_base + pde_index;  // IN INTEL PDE
	uint64_t pde_value;
	xa_read_long_long_mach(&xai, pde_entry, &pde_value);

	/* GET PTE VALUE */	
	uint64_t pte_base = pde_value & 0xFFFFFF000ULL;
	uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
	uint32_t pte_entry = pte_base + pte_index;  // IN INTEL PTE

	
//	gettimeofday(&start, NULL);
	total =0;
	total_dirty=0;
	total_clean=0;
	vaddr = 0xc0000000;
	uint64_t pte_base_cpy = pte_base;


	for(i=0; i < 512; i++){
		
		memory = xa_access_ma(&xai, pte_base_cpy + 8*i, &offset, PROT_READ);
		//memwrite = xa_access_ma(&xai, pte_base_cpy + 8*i, &writeoffset, PROT_WRITE);

		//printf("pte_base_cpy + 8*i: 0x%.8x offset:0x%.8x\n",pte_base_cpy+8*i,offset);
		//if (NULL != memory){
			
		//}
	
		for(j=0; j < 512; j++){
			
		//	xa_read_long_long_mach(&xai, pte_base_cpy + 8*j, &pte_value);
		
		//	xc_domain_pause(xc_handle,dom);			

			*(&pte_value) = *((uint64_t*)(memory + offset));

		//	xc_domain_unpause(xc_handle,dom);		
			
			//printf("pte_value: 0x%.8x ",pte_value);					

			//printf("%.2x %.2x %.2x %.2x %.2x %.2x %.2x %.2x \n",memory[0+offset],memory[1+offset],memory[2+offset],memory[3+offset],memory[4+offset],memory[5+offset],memory[6+offset],memory[7+offset]);
		
			offset = offset + 8;
		
			dirty = xa_get_bit(pte_value,6);
	
			if(dirty == 1){
			//	pte_value = pte_value | 64
			//	*(&pte_value) = *(&pte_value) | 64;
				//*((uint64_t*)(memwrite + writeoffset)) | 64;

				//test = &(*memwrite);
			
				//*test &= ~(1 << 6);
				
				//*memwrite = *memwrite & 0x23;
				//printf("%.2x %.2x %.2x\n",test[offset],test[offset] & ~(1 << 6), test[offset] & 0x23);			

				total_dirty++;
			}
		
			writeoffset = writeoffset + 8;
			//else{
			//	if(total_clean == 2549)
			//		printf("LAST CLEAN: 0x%.8x\n",vaddr); 
			//	total_clean++;
			//}
			

			/*printf("i: %d j: %d 0x%.8x  ",i,j,vaddr);
			printf("PDE base: 0x%.8x ",pde_base);
			printf("index: 0x%.8x ", i*8); 
			printf("entry: 0x%.8x \t",pde_base+i*8);

			printf("PTE: base: 0x%.8x ",pte_base);
			printf("index: 0x%.8x ", j*8);
			printf("entry: 0x%.8x\n\n",pte_base + j*8);
			*/
			vaddr = vaddr+0x1000;
			total++;
			if(vaddr == 0xe07e9000){
			//if(vaddr == 0xc042f000){
				i=512;
				j=512;
			}
		}

		pde_entry = pde_base + pde_index + 8*(i+1);

		xa_read_long_long_mach(&xai, pde_entry, &pde_value);
		pte_base_cpy = pde_value & 0xFFFFFF000ULL;
		munmap(memory, (&xai)->page_size);
	}
	
	xa_destroy(&xai);

	gettimeofday(&end, NULL);
	printf("%ld\n", ((end.tv_sec * 1000000 + end.tv_usec)
		- (start.tv_sec * 1000000 + start.tv_usec)));

	printf("total %d total_dirty %d\n",total, total_dirty);

	return 0;
}
