#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>
#include <time.h>
#include <sys/time.h>


xa_instance_t xai;

int main (int argc, char **argv)
{
	struct timeval start, end;
				
	gettimeofday(&start, NULL);

	int i=0, j=0;
	unsigned char *memory = NULL;
	uint32_t vaddr;
	uint32_t addr, offset;
	int count = 0;
	unsigned long mfn;

	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}

	for(vaddr = 0xc0000000; vaddr < 0xe07e9000;vaddr = vaddr+0x1000){
		//count++;
		//printf("vaddr: 0x%.8x count: %d\n",vaddr,count);
		addr = xa_translate_kv2p(&xai,vaddr);

		memory = xa_access_ma(&xai, addr, &offset,PROT_READ);
		if (memory) munmap(memory, xai.page_size);
	}	


	//65506



	gettimeofday(&end, NULL);
	printf("%ld\n", ((end.tv_sec * 1000000 + end.tv_usec)
		- (start.tv_sec * 1000000 + start.tv_usec)));

	return 0;
}
