#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>

int main (int argc, char **argv)
{
	xa_instance_t xai;
	unsigned char *memory = NULL;
	unsigned char systable[0x564];
	uint32_t offset;
	uint32_t addr;
	int size = 1380;
	int i;
	int detected = 0;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}
	
	printf("save sys_call_table state\n");

	addr = xa_translate_kv2p(&xai,0xc02d3450);
	printf("physical address of sys_call_table 0x%.8x\n",addr);

	/* get the memory page where sys_call_table is located */
	//memory = xa_access_kernel_va(&xai, 0xc02c9458, &offset, PROT_READ);
	memory = xa_access_ma(&xai, addr, &offset,PROT_READ);
	
	if (NULL == memory){
		perror("failed to map memory");
		return -1;
	}

	//print_hex(memory, xai.page_size);

	for(i = 0; i < 1380; i++){

		systable[i] = memory[offset + i];
	}

	/* sanity check to unmap shared pages */
	if (memory) munmap(memory, xai.page_size);

	printf("begin monitoring\n");

	
	while(1){
		uint32_t cr3 = xai.cr3;
		uint32_t vaddr = 0xc02d3450;

		/* GET PDPTE3 VALUE */
		/* page directory pointer table */
		uint32_t pdptb = cr3 & 0xFFFFFFE0;
		uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
		uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
		uint64_t pdpie_value;
		xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);


		/* GET PDE VALUE */
		uint64_t pdba_base = pdpie_value & 0xFFFFFF000ULL;
		uint32_t pgd_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
		uint32_t pgd_entry = pdba_base + pgd_index;  // IN INTEL PDE
		uint64_t pde_value;
		xa_read_long_long_mach(&xai, pgd_entry, &pde_value);

		/* GET PTE VALUE */	
		uint64_t ptba_base = pde_value & 0xFFFFFF000ULL;
		uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
		uint32_t pte_entry = ptba_base + pte_index;  // IN INTEL PTE
		uint64_t pte_value;
		xa_read_long_long_mach(&xai, pte_entry, &pte_value);

		int dirty = xa_get_bit(pte_value,6);

		//printf("dirty bit (bit 6 of PTE value): %d\n",dirty);

		if(dirty != 0){
			printf("dirty bit (bit 6 of PTE value): %d\n",dirty);
			printf("WARNING Dirty bit has changed in page where sys_call_table is located WARNING\n");

			memory = (unsigned char *)xa_access_ma(&xai, addr, &offset,PROT_READ);
			printf("check if sys_call_table has been changed\n");
	
			for(i = 0; i < 1380; i++){
				if(systable[i] != memory[offset + i]){
					printf("WARNING change in sys_call_table detected WARNING\n");
					detected = 1;
					break;
				}
			}		
		
			if(detected){
				printf("rootkit detected\n");
				break;
			}
			
			if (memory) munmap(memory, xai.page_size);

			break;
		} 
	}

	/* cleanup any memory associated with the XenAccess instance */
	xa_destroy(&xai);
	
	return 0;
}
