#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>
#include <time.h>
#include <sys/time.h>

xa_instance_t xai;
/*
int get_dirty(uint32_t vaddr, int i){


	uint32_t cr3 = xai.cr3;

	/* GET PDPTE3 VALUE */
	/* page directory pointer table */
/*	uint32_t pdptb = cr3 & 0xFFFFFFE0;
	uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
	uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
	uint64_t pdpie_value;
	xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);


	/* GET PDE VALUE */
/*	uint64_t pdba_base = pdpie_value & 0xFFFFFF000ULL;
	uint32_t pgd_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
	uint32_t pgd_entry = pdba_base + pgd_index;  // IN INTEL PDE
	uint64_t pde_value;
	xa_read_long_long_mach(&xai, pgd_entry, &pde_value);

	/* GET PTE VALUE */	
/*	uint64_t ptba_base = pde_value & 0xFFFFFF000ULL;
	uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
	uint32_t pte_entry = ptba_base + pte_index;  // IN INTEL PTE
	uint64_t pte_value;
	xa_read_long_long_mach(&xai, pte_entry, &pte_value);

	int dirty = xa_get_bit(pte_value,6);

	/*if(pte_entry != 0)
	printf("i: %d ",i);
	printf("0x%.8x PDPTE base: 0x%.8x ",vaddr, pdptb);
	printf("index: 0x%.8x ",pdpi_index);
	printf("entry: 0x%.8x \t", pdpi_entry);

	printf("PDE base: 0x%.8x ",pdba_base);
	printf("index: 0x%.8x ", pgd_index); 
	printf("entry: 0x%.8x \t",pgd_entry);

	printf("PTE: base: 0x%.8x ",ptba_base);
	printf("index: 0x%.8x ", pte_index);
	printf("entry: 0x%.8x\n\n",pte_entry);*/
	//return dirty;
//}


int main (int argc, char **argv)
{
	struct timeval start, end;

	gettimeofday(&start, NULL);

	uint32_t offset,addr,cr3,pdptb,pdpi_index,pdpi_entry,pgd_index,pgd_entry,pte_entry;
	uint64_t pdpie_value, pdba_base,pde_value,ptba_base,pte_index,pte_value;
	int dirty;	
	int size = 1380;
	int detected = 0;
	int total_dirty = 0;
	int i=0;
	uint32_t vaddr = 0xc0000000;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}

	cr3 = xai.cr3;

	//uint32_t vaddr = 0xc02c9458;
	while(i < 133097){
	//while(1){	
		/* GET PDPTE3 VALUE */
		/* page directory pointer table */
		pdptb = cr3 & 0xFFFFFFE0;
		pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
		pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
		pdpie_value;
		xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);
	
	
		/* GET PDE VALUE */
		pdba_base = pdpie_value & 0xFFFFFF000ULL;
		pgd_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
		pgd_entry = pdba_base + pgd_index;  // IN INTEL PDE
		pde_value;
		xa_read_long_long_mach(&xai, pgd_entry, &pde_value);
	
		/* GET PTE VALUE */	
		ptba_base = pde_value & 0xFFFFFF000ULL;
		pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
		pte_entry = ptba_base + pte_index;  // IN INTEL PTE
		pte_value;
		xa_read_long_long_mach(&xai, pte_entry, &pte_value);

		dirty = xa_get_bit(pte_value,6);

		/*printf("i: %d 0x%.8x ",i,vaddr);
		printf("0x%.8x PDPTE base: 0x%.8x ",vaddr, pdptb);
		printf("index: 0x%.8x ",pdpi_index);
		printf("entry: 0x%.8x \t", pdpi_entry);

		printf("PDE base: 0x%.8x ",pdba_base);
		printf("index: 0x%.8x ", pgd_index); 
		printf("entry: 0x%.8x \t",pgd_entry);

		printf("PTE: base: 0x%.8x ",ptba_base);
		printf("index: 0x%.8x ", pte_index);
		printf("entry: 0x%.8x\n\n",pte_entry);*/

		if(dirty == 1)
			total_dirty++;

		vaddr = vaddr + 0x1000;
		i++;
	}

	/* cleanup any memory associated with the XenAccess instance */
	xa_destroy(&xai);

	printf("total %d total_dirty %d\n",i,total_dirty);

	gettimeofday(&end, NULL);
	 printf("%ld\n", ((end.tv_sec * 1000000 + end.tv_usec)
		  - (start.tv_sec * 1000000 + start.tv_usec)));
	
	return 0;
}
