#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>

int main (int argc, char **argv)
{
	xa_instance_t xai;
	unsigned char *memory = NULL;
	unsigned char systable[0x564];
	uint32_t offset;
	uint32_t addr;
	int size = 1380;
	int i;
	int detected = 0;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}
	
	printf("save sys_call_table state\n");

	addr = xa_translate_kv2p(&xai,0xc02c9458);
	printf("physical address of sys_call_table 0x%.8x\n",addr);

	/* get the memory page where sys_call_table is located */
	//memory = xa_access_kernel_va(&xai, 0xc02c9458, &offset, PROT_READ);
	memory = xa_access_ma(&xai, addr, &offset,PROT_READ);
	
	if (NULL == memory){
		perror("failed to map memory");
		return -1;
	}

	
	printf("offset = 0x%.8x\n", offset);
	printf("CR3: 0x%.8x\n",xai.cr3);

	uint32_t pdpt = (((xai.cr3) >> 21) & 0x1FF) * sizeof(uint64_t);
	printf("PDPT: 0x%.8x\n",pdpt);

	printf("page size = 0x%.8x\n",xai.page_size);
	//print_hex(memory, xai.page_size);

	for(i = 0; i < 1380; i++){

		systable[i] = memory[offset + i];
	}

	/* sanity check to unmap shared pages */
	if (memory) munmap(memory, xai.page_size);

	printf("begin monitoring\n");
/*
	while(detected == 0){
		//memory = xa_access_kernel_va(&xai, 0xc02c9458, &offset, PROT_READ);
		memory = (unsigned char *)xa_access_ma(&xai, addr, &offset,PROT_READ);
		printf("check if sys_call_table has been changed\n");

		for(i = 0; i < 1380; i++){
			if(systable[i] != memory[offset + i]){
				printf("WARNING change in sys_call_table detected WARNING\n");
				detected = 1;
				break;
			}
		}		
	
		if(detected){
			printf("rootkit detected\n");
			break;
		}
		
		if (memory) munmap(memory, xai.page_size);

		sleep(10);
	}
*/	
	/* cleanup any memory associated with the XenAccess instance */
	xa_destroy(&xai);
	
	return 0;
}
