#include <linux/module.h>  
#include <linux/kernel.h>  
#include <linux/syscalls.h>
#include <linux/unistd.h>


static int my_init_module(void);
static void my_cleanup_module(void);

struct syscall_handler_t **sys_call_table;
asmlinkage ssize_t (*old_sys_write)(unsigned int fd, const char __user *buf, size_t count);

asmlinkage ssize_t new_sys_write(unsigned int fd, const char __user *buf, size_t count){
	return old_sys_write(fd,buf,count);
}

static int my_init_module(void)
{
	sys_call_table = (struct syscall_handler_t *)0xc02d3450;

	old_sys_write = sys_call_table[__NR_write]; // keep original pointer to sys_write
	printk("write: %d\n",__NR_write);
	sys_call_table[__NR_write] = new_sys_write; // insert new sys_write into table

	return 0;
}

static void my_cleanup_module(void)
{
	/* set sys_write function back to the old sys_write system call */
	
	sys_call_table[__NR_write] = old_sys_write;	
}

module_init(my_init_module);
module_exit(my_cleanup_module);

MODULE_LICENSE("GPL");
