#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>
#include <time.h>
#include <sys/time.h>


xa_instance_t xai;

int main (int argc, char **argv)
{
	struct timeval start, end;
	gettimeofday(&start, NULL);

	int i=0, j=0, total, total_dirty,total_clean;
	int dirty;	
	uint64_t pte_value;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}

	uint32_t cr3 = xai.cr3;
	uint32_t vaddr = 0xc0000000;

	/* GET PDPTE3 VALUE */
	/* page directory pointer table */
	uint32_t pdptb = cr3 & 0xFFFFFFE0;
	uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
	uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
	uint64_t pdpie_value;
	xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);


	/* GET PDE VALUE */
	uint64_t pde_base = pdpie_value & 0xFFFFFF000ULL;
	uint32_t pde_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
	uint32_t pde_entry = pde_base + pde_index;  // IN INTEL PDE
	uint64_t pde_value;
	xa_read_long_long_mach(&xai, pde_entry, &pde_value);

	/* GET PTE VALUE */	
	uint64_t pte_base = pde_value & 0xFFFFFF000ULL;
	uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
	uint32_t pte_entry = pte_base + pte_index;  // IN INTEL PTE

	//while(1){
	//	gettimeofday(&start, NULL);
		total =0;
		total_dirty=0;
		total_clean=0;
		vaddr = 0xc0000000;
		uint64_t pte_base_cpy = pte_base;
		
		for(i=0; i < 512; i++){
		
			for(j=0; j < 512; j++){
				
				xa_read_long_long_mach(&xai, pte_base_cpy + 8*j, &pte_value);
				dirty = xa_get_bit(pte_value,6);
		
				if(dirty == 1){
				//	pte_value = pte_value | 64
					total_dirty++;
				}
				//else{
				//	if(total_clean == 2549)
				//		printf("LAST CLEAN: 0x%.8x\n",vaddr); 
				//	total_clean++;
				//}
				
	
				/*printf("i: %d j: %d 0x%.8x  ",i,j,vaddr);
				printf("PDE base: 0x%.8x ",pde_base);
				printf("index: 0x%.8x ", i*8); 
				printf("entry: 0x%.8x \t",pde_base+i*8);
	
				printf("PTE: base: 0x%.8x ",pte_base);
				printf("index: 0x%.8x ", j*8);
				printf("entry: 0x%.8x\n\n",pte_base + j*8);
				*/
				vaddr = vaddr+0x1000;
				total++;
				if(vaddr == 0xe07e9000){
				//if(vaddr == 0xc042f000){
					i=512;
					j=512;
				}
			}
	
			pde_entry = pde_base + pde_index + 8*(i+1);
	
			xa_read_long_long_mach(&xai, pde_entry, &pde_value);
			pte_base_cpy = pde_value & 0xFFFFFF000ULL;
		}
		
		xa_destroy(&xai);

		gettimeofday(&end, NULL);
		printf("%ld\n", ((end.tv_sec * 1000000 + end.tv_usec)
			- (start.tv_sec * 1000000 + start.tv_usec)));
	
		printf("total %d total_dirty %d\n",total, total_dirty);



	
	return 0;
}
