#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>
#include <xenctrl.h>

int main (int argc, char **argv)
{
	xa_instance_t xai;
	unsigned char *memory = NULL;
	unsigned char systable[0x564];
	uint32_t offset;
	uint32_t addr;
	uint64_t *pdpte;
	int size = 1380;
	int i;
	int detected = 0;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		return -1;
	}
	
	printf("save sys_call_table state\n");

	addr = xa_translate_kv2p(&xai,0xc02c9458);
	printf("physical address of sys_call_table 0x%.8x\n",addr);
	

	printf("PAE: 0x%x\n",xai.pae);
	printf("PSE: %x\n",xai.pse);
	printf("CR3: 0x%.8x\n",xai.cr3);

	uint32_t cr3 = xai.cr3;
	uint32_t vaddr = 0xc0100000;

	/* 174 uint32_t get_pdptb (uint32_t pdpr) */
	/* page directory pointer table */
	uint32_t pdptb = cr3 & 0xFFFFFFE0;
	printf("page directory pointer table: 0x%.8x\n",pdptb);	

	/* 178 uint32_t pdpi_index (uint32_t pdpi) */
	uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
	printf("vaddr >> 30: 0x%x\n",vaddr >> 30);
	printf("size of uint64_t: 0x%x\n",sizeof(uint64_t)); 
	printf("pdpi_index: %d 0x%x\n",pdpi_index, pdpi_index);

	/*  185 uint32_t pdpi_entry = get_pdptb(cr3) + pdpi_index(vaddr);*/
	uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
	printf("\nPDPTEi pdpi_entry: 0x%.8x\n",pdpi_entry);

	uint64_t pdpie_value;
	xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);
	printf("PDPTEi Value: 0x%.16x\n\n",pdpie_value);

	uint64_t pdba_base = pdpie_value & 0xFFFFFF000ULL;
	printf("pdba_base: 0x%.8x\n",pdba_base); 
	
	uint32_t pgd_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
	printf("vaddr >> 21: 0x%.8x\n",(vaddr >> 21));
	printf("(vaddr >> 21) & 0x1FF: 0x%.8x\n",(vaddr >> 21) & 0x1FF);
	printf("pgd_index: 0x%.8x\n",pgd_index); 

	/* 221 uint32_t pgd_entry = pdba_base_pae(pdpe) + pgd_index(instance, vaddr); */
	uint32_t pgd_entry = pdba_base + pgd_index;  // IN INTEL PDE
	printf("\nPDE pgd_entry 0x%.8x\n",pgd_entry);

	uint64_t pde_value;
	xa_read_long_long_mach(&xai, pgd_entry, &pde_value);
	printf("PDE Value: 0x%.16x\n\n",pde_value);

	uint64_t ptba_base = pde_value & 0xFFFFFF000ULL;
	printf("ptba_base: 0x%.8x\n",ptba_base);

	uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
	printf("vaddr >> 12: 0x%.8x\n",(vaddr >> 12));
	printf("(vaddr >> 21) & 0x1FF: 0x%.8x\n",(vaddr >> 12) & 0x1FF);
	printf("pte_index: 0x%.8x\n",pte_index); 

	/* 253  uint32_t pte_entry = ptba_base_pae(pgd) + pte_index(instance, vaddr); */
	uint32_t pte_entry = ptba_base + pte_index;  // IN INTEL PTE
	printf("\nPTE ptd_entry 0x%.8x\n",pte_entry);

	uint64_t pte_value;
	xa_read_long_long_mach(&xai, pte_entry, &pte_value);
	printf("PTE Value: 0x%.16x\n\n",pte_value);

	uint32_t page = pte_value & 0xFFFFFF000ULL | (vaddr & 0xFFF);
	printf("page: 0x%.8x\n",page);

	printf("dirty bit (bit 6 of PTE value): %d\n",xa_get_bit(pte_value,6)); 
	
	
	

	

	if (NULL == memory){
		perror("failed to map memory");
		return -1;
	}


	//uint32_t pgd_index = (((xai.cr3) >> 21) & 0x1FF) * sizeof(uint64_t);
//	uint32_t pdpt = xai.cr3 & 0xFFFFFFE0;
//	printf("PDPT: 0x%.8x\n",pdpt);

//	printf("page size = 0x%.8x\n",xai.page_size);
	print_hex(memory, xai.page_size);

	/* sanity check to unmap shared pages */
	if (memory) munmap(memory, xai.page_size);

	
	/* cleanup any memory associated with the XenAccess instance */
	xa_destroy(&xai);
	
	return 0;
}
