#include <stdio.h>
#include <stdlib.h>
#include <xenaccess/xenaccess.h>

int main (int argc, char **argv)
{
	xa_instance_t xai;
   /* this is the domain ID that we are looking at */
    uint32_t dom = atoi(argv[1]);
    /* initialize the xen access library */
    if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
            perror("failed to init XenAccess library");
            return -1;
    }

	uint32_t vaddr = atoi(argv[2]); 

	uint32_t mach = xa_translate_kv2p(&xai,vaddr);
	printf("vaddr: 0x%x ",vaddr);
	printf("xa_translated: 0x%x\n",mach);

	uint32_t cr3 = xai.cr3;

	printf("cr3: 0x%x\n",cr3); 
	printf("pae: %d\n",&xai.pae);

	/* GET PDPTE3 VALUE */
    /* page directory pointer table */
    uint32_t pdptb = cr3 & 0xFFFFFFE0;
    uint32_t pdpi_index = (vaddr >> 30) * sizeof(uint64_t);
    uint32_t pdpi_entry = pdptb + pdpi_index;  // IN INTEL PDPTEi
    uint64_t pdpie_value;
    xa_read_long_long_mach(&xai, pdpi_entry, &pdpie_value);


    /* GET PDE VALUE */
    uint64_t pde_base = pdpie_value & 0xFFFFFF000ULL;
    uint32_t pde_index = (((vaddr) >> 21) & 0x1FF) * sizeof(uint64_t);
    uint32_t pde_entry = pde_base + pde_index;  // IN INTEL PDE
    uint64_t pde_value;
    xa_read_long_long_mach(&xai, pde_entry, &pde_value);
	printf("pde_value: 0x%x\n",pde_value);

    /* GET PTE VALUE */
    uint64_t pte_base = pde_value & 0xFFFFFF000ULL;
    uint64_t pte_index = (((vaddr) >> 12) & 0x1FF) * sizeof(uint64_t);
    uint32_t pte_entry = pte_base + pte_index;  // IN INTEL PTE
	uint64_t pte_value;
	xa_read_long_long_mach(&xai, pte_entry, &pte_value);
	printf("pte_value: 0x%x\n",pte_value);

	uint32_t page = pte_value & 0xFFFFFF000ULL | (vaddr & 0xFFF);
    printf("page: 0x%.8x\n",page);
}
