/*------------------------------------------------------------------------
 * File:	alpha_reduction_simul.cc
 *
 * Author:	Liu Yang
 * Date:	Sep 2, 2009
 *
 * Test simulation by doing alphabet reduction
 *------------------------------------------------------------------------
 * $Log: alpha_reduction_simul.cc,v $
 * Revision 1.2  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 *
 * */


#include <iostream>
#include <cstdlib>
#include <fstream>
#include <map>
#include <set>
#include <vector>
#include <cstdlib>
#include <stdio.h>
#include <string.h>

#include <unistd.h>
#include <pcap.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <errno.h> 

#include "nfa-multimap.h"
#include "clock.h"
#include "packet.h"
#include "decode.h"

//#define DISPAY_ALPHA_MAP

using namespace std;

typedef struct raw_packet
{
      int                allocated; // >0 iff pkt points to allocated data
      unsigned char      *pkbuf;
      packet             pkt;
      unsigned long      id;
      struct pcap_pkthdr hdr;
} raw_packet_t;


string trace_file;

pcap_t *pcap_handle;

/*-----------------------------------------------
 * Function Prototypes
 *----------------------------------------------*/

void init_pcap(pcap_t **handle, string& fname);
int get_next_packet(pcap_t *handle, raw_packet_t* pkt);

int main (int argc, char **argv) {
  int i;
  unsigned long long starttm = 0;
  unsigned long long stoptm = 0;
  unsigned long long total_cycles = 0;
  size_t total_bytes = 0;  
  nfa_map_t nfa_dt;

  if (argc != 3) {
    cerr << "Usage: alpha_reduction_simul <NFA file name> <trace file>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  nfa_dt.fill_trans_tab(argv[1]);
  nfa_dt.alphabet_reduction();

#ifdef DISPAY_ALPHA_MAP
  cout << "After alphabet reduction:" << endl;
  for (i = 0; i < ALPHABET_SIZE; i++) {
    cout << i << "->" << (unsigned int)nfa_dt.class_c[i] << endl;
  }
#endif

  /* generate the reduced transition table */
  nfa_dt.rdt_trans_tab_gen();
  //nfa_dt.dump_rdt_transitions("reduced_trans_http_10.txt");

  trace_file = argv[2];
  init_pcap(&pcap_handle, trace_file);

  raw_packet_t rp;
  unsigned char *iphdr, *tcphdr, *payload;
  size_t tcphdr_len = 20;	/* default length of tcp header */
  size_t iphdr_len = 20;
  int payload_sz = 0;
  size_t total_payload_bytes = 0;
  while (get_next_packet(pcap_handle, &rp)) {
    /* locate the payload */
    iphdr = rp.pkbuf + 14;	/* skip the link hdr */
    iphdr_len = (*iphdr & 0x0f) * 4;	/* extract the length of ip hdr */
    tcphdr = iphdr + iphdr_len;
    tcphdr_len = ((*(tcphdr + 12) >> 4) & 0x0f) * 4;
    payload = tcphdr + tcphdr_len;
    payload_sz = rp.hdr.caplen - 14 - iphdr_len - tcphdr_len;

    if (payload_sz > 0) {
      rdtsc(starttm);
      nfa_dt.rdt_simulate(payload, payload_sz);
      rdtsc(stoptm);
      total_payload_bytes += payload_sz;
      total_cycles += (stoptm - starttm);
      if (rp.allocated) {
        free(rp.pkbuf);
        rp.allocated = 0;
      }
    }
    total_bytes += rp.hdr.caplen;
  }
  
  cout << "Total payload bytes: " << total_payload_bytes << endl;
  cout << "Total bytes including packet headers: " << total_bytes << endl;
  cout << "Total cycles: " << total_cycles << endl;

  cout << "Simulation: execution time is " << (double)total_cycles/(double)total_payload_bytes << " cycles/byte" << endl;

  return 0;
}

/*--------------------------------
 * init_pcap
 * -------------------------------*/
void init_pcap(pcap_t **handle, string& fname)
{
   char errbuf[PCAP_ERRBUF_SIZE];

   *handle = pcap_open_offline(fname.c_str(), errbuf);
   if (handle == NULL)
   {
      fprintf(stderr, "pcap_open failed: %s\n", errbuf);
      exit(0);
   }
   fprintf(stdout, "Opened trace file %s\n", fname.c_str());
}

/*--------------------------------------
 * get_next_packet
 *-------------------------------------*/
int get_next_packet(pcap_t *handle, raw_packet_t* pkt)
{
   static int id=0;
   const u_int8_t *data;

   data = pcap_next(handle, &(pkt->hdr));
   if (!data)
      return 0;

   pkt->pkbuf = (u_int8_t *)calloc(1, pkt->hdr.caplen);
   memcpy(pkt->pkbuf, data, pkt->hdr.caplen);
   pkt->allocated = 1;
   return 1;
}

