/*---------------------------------------------------------------------------
 * File:	dfa_simulate.cc
 *
 * Author:	Liu Yang
 * Date:	Aug 6, 2009
 *
 * Match test for DFA
 *------------------------------------------------------------------------
 * $Log: dfa_simulate.cc,v $
 * Revision 1.1  2009/09/02 01:57:00  lyangru
 * startup
 *
 *
 *-----------------------------------------------------------------------*/


#include <iostream>
#include <fstream>
#include <map>
#include <set>
#include <vector>
#include <string>
#include <cstdlib>
#include <string.h>
#include <stdio.h>

#include "nfa-multimap.h"
#include "clock.h"

#define NUM_OF_TEST_ROUND	10 
#define BUF_SIZE		200000

//#define DEBUG

int main(int argc, char** argv) {

  FILE *str_file = NULL;
  unsigned int i, j, line_no = 0;
  unsigned long long starttm = 0;
  unsigned long long stoptm = 0;
  unsigned long long total_cycles = 0;
  char *p;
  size_t payload_sz = 0;
  size_t total_bytes = 0;
  char buf[BUF_SIZE];
  unsigned int t_start, t_end;

  dfa_trans_t dfa_dt;

  if (argc != 3) {
    cerr << "Usage: %s <DFA file name> <stream file>" << endl;
    exit(1);
  }

  /* fill out the transition table */
  dfa_dt.fill_trans_tab(argv[1]);

  /* ----read stream for match test---- */
  str_file = fopen(argv[2], "r");

  if (str_file == NULL) {
    cerr << "File could not be openned" << endl;
    exit(1);
  }

  t_start = cputime();

  memset(buf, 0, BUF_SIZE);
  p = fgets(buf, BUF_SIZE, str_file);
  while (p != NULL) {
    payload_sz = strlen(p);
    p[payload_sz-1] = '\0';
    rdtsc(starttm);
    dfa_dt.simulate((const unsigned char *)p, payload_sz);
    rdtsc(stoptm);
    total_bytes += payload_sz;
    total_cycles += (stoptm - starttm);
    memset(buf, 0, BUF_SIZE);
    p = fgets(buf, BUF_SIZE, str_file);
  }

  t_end = cputime();

  cout << "DFA simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl;

  cout << "Total time spent on DFA simulation: " << (double)(t_end - t_start)/(double)1000 << " seconds" << endl;

  fclose(str_file);

  return 0;
}


