/*------------------------------------------------------------------------
 * File:	kgram_alpha_rdt_simul.cc
 *
 * Author:	Liu Yang
 * Date:	Sep 6, 2009
 *
 * Perform match test based on reduced digram alphabet
 *------------------------------------------------------------------------
 * $Log: kgram_alpha_rdt_simul.cc,v $
 * Revision 1.3  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 *
 * */
#include <sys/time.h>
#include <sys/resource.h>
#include <cstdlib>
#include <string.h>
#include "clock.h"
#include "kgram.h"


#define BUF_SIZE		2000

//#define DEBUG

int cputime();

int main(int argc, char** argv) {
  FILE *str_file = NULL;
  unsigned long long starttm = 0, stoptm = 0;
  unsigned long long total_cycles = 0;
  unsigned int t_start = 0, t_end = 0;
  char *p;
  size_t payload_sz = 0;
  size_t total_bytes = 0;
  char buf[BUF_SIZE];
  unsigned char len_pad = 0, act_pad = 0;
  unsigned int i, cnt = 0;
  unsigned int mapped_buf[BUF_SIZE];
  map<string, unsigned int>::iterator itm;

  kgram_nfa k_nfa;

  if (argc != 3) {
    cerr << "Usage: kgram_simul <reduced digram NFA file name> <trace file>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  k_nfa.kgram_size = 2;	/* don't forget this */
  k_nfa.fill_rdt_trans_tab(argv[1]);

#ifdef DEBUG
  cout << "digram reduced transitions loaded" << endl;
#endif

  /* ----read stream for match test---- */
  str_file = fopen(argv[2], "r");
  if (str_file == NULL) {
    cerr << "File could not be openned" << endl;
    exit(1);
  }

  memset(buf, 0, BUF_SIZE);
  p = fgets(buf, BUF_SIZE, str_file);
  while (p != NULL) {
    payload_sz = strlen(p) - 1;
    // decide the length of padding 
    len_pad = 2 - (unsigned char)(payload_sz % 2);
    if ((len_pad > 0) && (len_pad < 2)) {
      act_pad = len_pad;
      for (i = 0; i < len_pad; i++) {
        p[payload_sz+i] = 0;
      }
      p[payload_sz+i] = '\0';
    } else { 
      p[payload_sz] = '\0';
      act_pad = 0;
    }
    /* convert to new aphabets before simulation */
    cnt = 0;
    memset(mapped_buf, 0, BUF_SIZE * sizeof(unsigned int));
    for (i = 0; i < payload_sz; i = i + k_nfa.kgram_size) {
      string cur_dg((const char*)(p + i), (size_t)k_nfa.kgram_size);
      mapped_buf[cnt] = k_nfa.class_c[cur_dg];
      cnt++;
    }
    rdtsc(starttm);
    k_nfa.rdt_simulate2(mapped_buf, cnt);
    rdtsc(stoptm);
    total_bytes += payload_sz;
    total_cycles += (stoptm - starttm);
    memset(buf, 0, BUF_SIZE);
    p = fgets(buf, BUF_SIZE, str_file);
  }
  
  cout << "Simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl;

  fclose(str_file);

  return 0;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}
