/*------------------------------------------------------------------------
 * File:	kgram_alpha_reduction.cc
 *
 * Author:	Liu Yang
 * Date:	Sep 6, 2009
 *
 * Perform digram alphabet reduction
 *------------------------------------------------------------------------
 * $Log: kgram_alpha_reduction.cc,v $
 * Revision 1.2  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 *
 * */
#include <sys/time.h>
#include <sys/resource.h>
#include <cstdlib>
#include <string.h>
#include "clock.h"
#include "kgram.h"


#define BUF_SIZE		200000

//#define DEBUG

int cputime();

int main(int argc, char** argv) {
  FILE *str_file = NULL;
  unsigned long long starttm = 0, stoptm = 0;
  unsigned long long total_cycles = 0;
  unsigned int t_start = 0, t_end = 0;
  char *p;
  size_t payload_sz = 0;
  size_t total_bytes = 0;
  char buf[BUF_SIZE];
  unsigned char len_pad = 0;
  unsigned i;
  map<string, unsigned int>::iterator itm;

  kgram_nfa k_nfa;

  if (argc != 5) {
    cerr << "Usage: kgram_simul <NFA file name> <gram size> <output (reduced) NFA file name> <stream file>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  k_nfa.kgram_size = atoi(argv[2]);
  k_nfa.fill_trans_tab(argv[1]);
  k_nfa.construct_multi_byte_trans(k_nfa.kgram_size);
  //k_nfa.output_kgram("digram_trans");
  t_start = cputime();
  k_nfa.alphabet_reduction_im();
  t_end = cputime();

  cout << "Time for alphabet reduction " << (double)(t_end - t_start)/(double)1000 << " seconds" << endl;

  k_nfa.rdt_trans_tab_gen();
  k_nfa.dump_rdt_transitions(argv[3]);

#ifdef DEBUG
  cout << "After k-alphabet reduction" << endl;
  for (itm = k_nfa.class_c.begin(); itm != k_nfa.class_c.end(); itm++) {
    cout << itm->first << " " << itm->second << endl;
  } 
#endif
  /* ----read stream for match test---- */
  str_file = fopen(argv[4], "r");

  if (str_file == NULL) {
    cerr << "File could not be openned" << endl;
    exit(1);
  }

  memset(buf, 0, BUF_SIZE);
  p = fgets(buf, BUF_SIZE, str_file);
  while (p != NULL) {
    payload_sz = strlen(p) - 1;
#ifdef DEBUG
  cout << p << endl;
  cout << "strlen(p)" << strlen(p) << endl;
#endif
    // decide the length of padding 
    len_pad = k_nfa.kgram_size - (unsigned char)(payload_sz % k_nfa.kgram_size);
    if ((len_pad > 0) && (len_pad < k_nfa.kgram_size)) {
    cout << "len_pad = " << (int)len_pad << endl;
      for (i = 0; i < len_pad; i++) {
        p[payload_sz+i] = 0;
      }
      p[payload_sz+i] = '\0';
    } else 
      p[payload_sz] = '\0';
    rdtsc(starttm);
    //k_nfa.simulate2((const unsigned char *)p, payload_sz, 2);
    k_nfa.rdt_simulate((const unsigned char *)p, payload_sz);
    rdtsc(stoptm);
    total_bytes += payload_sz;
    total_cycles += (stoptm - starttm);
    memset(buf, 0, BUF_SIZE);
    p = fgets(buf, BUF_SIZE, str_file);
  }
  
  cout << "Simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl;

  fclose(str_file);

  return 0;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}
