/*------------------------------------------------------------------------
 * File:	kgram_big_trans_build.cc
 *
 * Author:	Liu Yang
 * Date:	Oct 8, 2009
 *
 * Build transition tables from a given reduced alphabet
 *------------------------------------------------------------------------
 * $Log: kgram_big_trans_build.cc,v $
 * Revision 1.3  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 *
 * */

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <cstdlib>
#include <string>
#include <fstream>
#include <cstdlib>
#include <algorithm>
#include <string.h>
#include "clock.h"
#include "kgram.h"

#define DEBUG

#define FALSE 0
#define TRUE !FALSE


using namespace std;

extern int alphasort();
int file_select(const struct dirent *entry);

int main(int argc, char** argv) {

  int i, count;
  struct dirent **files;
  char trans_file[1024], out_file[1024];
  kgram_nfa *cur_knfa;

  if (argc != 4) {
    cerr << "Usage: kgram_big_trans_build <path of individual NFA's> <gram size> <kgram mapping file name>" << endl;
    exit(0);
  }

  count = scandir(argv[1], &files, file_select, alphasort);
  if (count <= 0) {
    printf("Invalid path name %s or empty directory\n", argv[1]);
    exit(0);
  }

  for (i = 0; i < count; i++) {
    if (strncmp(files[i]->d_name, ".", 1) != 0) {
    memset(trans_file, 0, 1024);
    memset(out_file, 0, 1024);
    strcpy(trans_file, argv[1]);
    trans_file[strlen(argv[1])] = '/';
    strcpy(trans_file + strlen(argv[1]) + 1, files[i]->d_name);
    printf("processing file %s ...\n", trans_file);
    cur_knfa = new kgram_nfa();
    cur_knfa->kgram_size = atoi(argv[2]);
    cur_knfa->fill_trans_tab(trans_file);
    cur_knfa->construct_multi_byte_trans(cur_knfa->kgram_size);
    cur_knfa->load_kgram_mapping(argv[3]);
    cur_knfa->rdt_trans_tab_gen();
#ifdef DEBUG
  printf("after rdt_trans_tab_gen()\n");
#endif
    /* process HTTP signatures */
    //sprintf(out_file, "/overseacloud/local/rdt_trans_tables/trans_merged_mapping_http_1_1400/rdt_digram_trans_from_%s", files[i]->d_name);
    sprintf(out_file, "/res/users/lyangru/BDD/multimap-nfa/temp/trans-merged-mapping-http-2604/rdt-digram-trans-from-%s", files[i]->d_name);
    /* process FTP signatures */
    //sprintf(out_file, "/overseacloud/local/rdt_trans_tables/trans_merged_mapping_ftp_1_96/rdt_digram_trans_from_%s", files[i]->d_name);
    //sprintf(out_file, "/res/users/lyangru/temp/trans_merged_mapping_ftp_1_96/rdt_digram_trans_from_%s", files[i]->d_name);
    //sprintf(out_file, "rdt_digram_trans_%s", files[i]->d_name);
    cur_knfa->dump_rdt_transitions(out_file);
    delete cur_knfa;
    }
  }

  return 0;
}

int file_select(const struct dirent *entry) {
  if ((strcmp(entry->d_name, ".") == 0) ||
       strcmp(entry->d_name, "..") == 0) {
    return (FALSE);
  } else
    return (TRUE);
}


