/*------------------------------------------------------------------------
 * File:	kgram_simul.cc
 *
 * Author:	Liu Yang
 * Date:	Aug 4, 2009
 *
 * Test multi-byte match simulation
 *------------------------------------------------------------------------
 * $Log $
 *
 * */


#include <cstdlib>
#include <string.h>
#include "clock.h"
#include "kgram.h"

#define BUF_SIZE		200000

//#define DEBUG

int main(int argc, char** argv) {
  FILE *str_file = NULL;
  unsigned long long starttm = 0, stoptm = 0;
  unsigned long long total_cycles = 0;
  char *p;
  size_t payload_sz = 0;
  size_t total_bytes = 0;
  char buf[BUF_SIZE];
  unsigned char len_pad = 0;
  unsigned i;

  kgram_nfa k_nfa;

  if (argc != 4) {
    cerr << "Usage: kgram_simul <NFA file name> <gram size> <stream file>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  k_nfa.kgram_size = atoi(argv[2]);
  k_nfa.fill_trans_tab(argv[1]);
  k_nfa.construct_multi_byte_trans(k_nfa.kgram_size);
  //k_nfa.output_kgram("digram_trans");

  /* ----read stream for match test---- */
  str_file = fopen(argv[3], "r");

  if (str_file == NULL) {
    cerr << "File could not be openned" << endl;
    exit(1);
  }

  memset(buf, 0, BUF_SIZE);
  p = fgets(buf, BUF_SIZE, str_file);
  while (p != NULL) {
    payload_sz = strlen(p);
    /* decide the length of padding */
    len_pad = k_nfa.kgram_size - (unsigned char)(payload_sz % k_nfa.kgram_size);
    if ((len_pad > 0) && (len_pad < k_nfa.kgram_size)) {
    cout << "len_pad = " << (int)len_pad << endl;
      for (i = 0; i < len_pad; i++) {
        p[payload_sz+i] = 0;
      }
      p[payload_sz+i] = '\0';
    } else 
      p[payload_sz] = '\0';
    rdtsc(starttm);
#ifdef DEBUG
  cout << "before simulation ..." << endl;
#endif
    k_nfa.simulate2((const unsigned char *)p, payload_sz, 2);
#ifdef DEBUG
  cout << "after simulation ..." << endl;
#endif
    rdtsc(stoptm);
    total_bytes += payload_sz;
    total_cycles += (stoptm - starttm);
    memset(buf, 0, BUF_SIZE);
    p = fgets(buf, BUF_SIZE, str_file);
  }
  
  cout << "Simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl;

  fclose(str_file);

  return 0;
}
