/*---------------------------------------------------------------------------
 * File:	match_test.cc
 *
 * Author:	Liu Yang
 * Date:	Jun 28, 2009
 *
 * Match test for NFA/DFA
 * Switch to measure the performance by CPU cycles
 *------------------------------------------------------------------------
 * $Log: match_test.cc,v $
 * Revision 1.9  2010/09/27 14:21:07  lyangru
 * final synchronization
 *
 * Revision 1.1  2009/09/02 01:57:00  lyangru
 * startup
 *
 * */

#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <string>
#include <cstdlib>
#include <string.h>
#include <stdio.h>
#include "nfa-multimap.h"
#include "clock.h"

#define NUM_OF_TEST_ROUND	10
#define BUF_SIZE		200000

//#define DEBUG

int main(int argc, char** argv) {
  multimap_nfa *mynfa;
  FILE *str_file = NULL;
  unsigned long long starttm = 0;
  unsigned long long stoptm = 0;
  unsigned long long total_cycles = 0;
  char *p;
  size_t payload_sz = 0;
  size_t total_bytes = 0;
  char buf[BUF_SIZE];
  nfa_map_t nfa_dt;

  if (argc !=3) {
    cerr << "Usage: ./match_test <nfa transition file> <string file>" << endl;
    exit(1);
  }

  nfa_dt.fill_trans_tab(argv[1]);
  nfa_dt.alphabet_reduction_im();

  /* generate the reduced transition table */
  nfa_dt.rdt_trans_tab_gen();

  /* epsilon elimination has been moved to eps_elimination.cc */
  /* read the stream to test */
  str_file = fopen(argv[2], "r");

  if (str_file == NULL) {
    cerr << "File could not be openned" << endl;
    exit(1);
  }

  memset(buf, 0, BUF_SIZE);
  p = fgets(buf, BUF_SIZE, str_file);
  while (p != NULL) {
    payload_sz = strlen(p);
    p[payload_sz-1] = '\0';
    /* start the timer */
    rdtsc(starttm);
    /* do simulation */
    //nfa_dt.simulate((const unsigned char *)p, payload_sz);
    nfa_dt.rdt_simulate((const unsigned char *)p, payload_sz);
    /* stop the timer */
    rdtsc(stoptm);
    total_bytes += payload_sz;
    total_cycles += (stoptm - starttm);
    /* get the next line of input */
    memset(buf, 0, BUF_SIZE);
    p = fgets(buf, BUF_SIZE, str_file);
  }

#ifdef DEBUG
  cout << "total str len is " << total_bytes << endl;
#endif

  cout << "Revised Simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl; 

  fclose(str_file);  

  return 0;
}
