/*---------------------------------------------------------------------------
 * File:	str_gen.cc
 *
 * Author:	Liu Yang
 * Date:	Jun 28, 2009
 *
 * Generate random string for NFA/DFA testing
 *------------------------------------------------------------------------
 * $Log: str_gen.cc,v $
 * Revision 1.2  2010/09/27 14:21:07  lyangru
 * final synchronization
 *
 * Revision 1.1  2009/09/02 01:57:00  lyangru
 * startup
 *
 * */


#include <iostream>
#include <string>
#include <fstream>
#include <map>
#include <set>
#include <vector>
#include <cstdlib>
#include <string.h>
#include "nfa-multimap.h"

int main() {
  char alpha[] = "abcdefghijklmnopqrstuvw12345789";
  char bit_alph[] = "0101010010011010101010101010101";


/* generate test strings */
  generate_test_strings("calendar admin.pl", alpha, 8, 100, "calender.strs");
  generate_test_strings("cmd\"&", alpha, 4, 100, "cmd.strs");
  generate_test_strings("<OBJECT>classid=11cf-9377", alpha, 7, 100, "OBJECT.strs");
  generate_test_strings("d", alpha, 1, 100, "d.strs");
  generate_test_strings("abcd", alpha, 2, 100, "abcd.strs");
  generate_test_strings("10000", bit_alph, 2, 100, "bit.strs");

  return 0;
}
