/*---------------------------------------------------------------------------
 * File:	test.cc
 *
 * Author:	Liu Yang
 * Date:	Jun 14, 2009
 *
 * Test the nfa-multimap implementation
 *------------------------------------------------------------------------
 * $Log: test.cc,v $
 * Revision 1.6  2010/09/27 14:21:07  lyangru
 * final synchronization
 *
 * Revision 1.1  2009/09/02 01:57:00  lyangru
 * startup
 *
 * Revision 1.3  2009/06/22 13:43:52  lyangru
 * Test the combination and output function
 * */


#include <iostream>
#include <map>
#include <string>
#include <vector>
#include <set>
#include <fstream>
#include <cstdlib>
#include <string.h>
#include "nfa-multimap.h"

#define DEBUG

int main(int argc, char** argv) {

  ifstream nfa_file;
  vector<int> accepting_states;
  multimap_nfa *mynfa;
  set<int> s_next;

  char str[][30] = {"calendar.pl", "calendar admin.pl", "acalendar-admin.pl", "bcalendar( admin).pl", "ccalendar( admin).pl"};
//  char str[][20] = {"acmd\"&", "cmd\"a&", "cmd\"b&", "cmd\"c&", "cmd\"&d"}; /* works */
//  char str[][40] = {"<OBJECT>classid=11cf-9377", "<OBJECT^aclassid=11cf-9377", "<OBJECTaclassid=11cf-9377", "<OBJECTbclassid=11cf-9377", "<OBJECT-classid=11cf-9377"};
//  char str[][26] = {"<\0O\0B\0>\0c\0l\0s=\01\0c\0-\09\03\0", "<\0C\0B\0>\0c\0l\0s=\01\0c\0-\09\03\0", "<\0D\0B\0>\0c\0l\0s=\01\0c\0-\09\03\0", "<\0E\0B\0>\0c\0l\0s=\01\0c\0-\09\03\0", "<\0F\0B\0>\0c\0l\0s=\01\0c\0-\09\03\0"}; /* works */
//  char str[][20] = {"d", "abce", "aabcd", "babcd", "&23abcd", "_9jhdsdfasabcd"}; /* works */
//  char str[][20] = {"abcd", "aabce", "babcd", "ab*&^^0cd", "ab_9jhdsdfasabcd"}; /* works */
//  char str[][10] = {"100000", "10000", "100000", "010000", "111010000"}; /* works */
  int i;

  if (argc !=2) {
    cerr << "Usage: %s <file name>" << endl;
    exit(1);
  }

  mynfa = new multimap_nfa(argv[1], false);

  /* do epsilon elimination for NFA */  
  mynfa->epsilon_elimination();
  /*mynfa->out_to_file("epsilon-eliminated-nfa");*/

  /* test accept_or_not */
  for (i = 0; i < 5; i++) {
    if (mynfa->accept_or_not_stream(str[i]))
    //if (mynfa->accept_or_not(str[i]))
      cout << str[i] << " is accepted" << endl;
    else
      cout << str[i] << " is not accepted" << endl;
  }

  delete mynfa;

  return 0;
}

