/*----------------------------------------------------------------------------*
 * file: clock.h
 *
 * author: Randy Smith
 *
 * Definitions used for accessing pentium performance counters
 *
 *
 *
 *-----------------------------------------------------------------------------
 *$Log: clock.h,v $
 *
 *---------------------------------------------------------------------------*/
#ifndef CLOCK_H
#define CLOCK_H

//#define rdtsc(val) __asm__ __volatile__ ("rdtsc" : "=&A" (val))



#define rdtsc_int(val) __asm__ __volatile__ ("rdtsc" : "=&A"(val))
#define cpuid __asm__ __volatile__ ("movl $0, %%eax\n\tcpuid" : : : "%eax", "%ebx", "%ecx", "%edx")
#define rdtsc(val) rdtsc_int(val);


/* Processor speed definitions (found in /proc/cpuinfo)
 * 1. eagles.cs.wisc.edu
 * 2. sights (at home) */

//#define PROC_MHZ 996789000
//#define CLOCK_HZ 3000242000LU
//#define PROC_MHZ 807213000
double CLOCK_HZ;

#endif

/*------------------------------------------------
 * Pseudocode for the measurements
 * unsigned long long starttm=0;
unsigned long long stoptm=0;
.
.
.

main processing loop:
   read in packet;
   packets_extracted++;
   rdtsc(starttm);

   match packet;

   rdtsc(stoptm);

   total_bytes += pay_sz;
   total_cycles += (stoptm - starttm);
end main processing loop.

 ------------------------------------------------*/

