/* ----------------------------------------------------------------------------
 * decode.h
 *   Routines for decoding a pcap-encoded packet.  These routines are drawn
 *   and pared from snort:  I'm only interested in Eth->IP->{TCP|UDP} for
 *   now, whereas Snort is decoding all kinds of things.
 *
 *
 * ----------------------------------------------------------------------------
 * History:
 *  $Log: decode.h,v $
 *  Revision 1.1.1.1  2006/02/24 22:10:58  smithr
 *  ips research code
 *
 *  Revision 1.3  2005/07/31 02:43:35  smithr
 *  all plugins checked in, code compiles.
 *
 *  Revision 1.2  2005/07/20 23:24:50  smithr
 *  Miscellaneous updates; working on verifying flow functionality
 *
 *  Revision 1.1  2005/07/19 16:30:16  smithr
 *  Initial check-in to CVS.  packet/decoding framework for ethernet
 *  packets is working.
 *
 *
 * --------------------------------------------------------------------------*/
#ifndef DECODE_H
#define DECODE_H

#include <sys/types.h>
#include "packet.h"

void decode_eth_pkt(packet *, struct pcap_pkthdr *, u_int8_t *);
void decode_ip(u_int8_t * pkt, const u_int32_t len, packet * p);
void decode_IP_options(u_int8_t *start, u_int32_t o_len, packet *p);
static inline int opt_len_validate(u_int8_t *option_ptr, u_int8_t *end,
				   u_int8_t *len_ptr, int expected_len,
				   Options *tcpopt, u_int8_t *byte_skip);
void decode_TCP(u_int8_t * pkt, const u_int32_t len, packet * p);
void decode_UDP(u_int8_t * pkt, const u_int32_t len, packet * p);
void decode_ICMP(u_int8_t * pkt, const u_int32_t len, packet * p);
void decode_TCP_options(u_int8_t *start, u_int32_t o_len, packet *p);
int decode_IP_only(u_int8_t * pkt, const u_int32_t len, packet * p);

#endif
