/*--------------------------------------------------------------
 * dfa_combination.cc
 * Combine multiple DFA's into one DFA 
 *
 * Author: Liu Yang
 * Date:   Aug 6, 2009
 *
 * Commented the nfa_minimize() operation due to the fact that it
 * may generate multiple accept ids during the minimization.
 * -------------------------------------------------------------
 *  History:
 *  $Log$
 * 
 * ------------------------------------------------------------*/
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "re.h"
#include "nfa.h"
#include "minimize.h"
#include "globals.h"
#include <sys/time.h>
#include <sys/resource.h>

#define MAX_STRING_LEN	256
#define NUM_OF_TEST_ROUND	1

/* this is defined in combine_alg.cc */
nfa_t* combine(nfa_t* NFA1, nfa_t* NFA2);

int cputime();

int main (int argc, char *argv[]) {

  FILE *f = NULL;
  char buf[4096];
  char *p;
  int line = 1;
  unsigned int sid = 1;
  nfa_t *NFA;
  nfa_t *DFA;
  nfa_t *com_dfa, *tmp_dfa;
  //dfa_tab_t com_dt;

  int start, end;

  int i = 0;

   
   if (argc != 3) {
     printf("Usage: %s <regex file name> <output file name>\n", argv[0]);
   }

   if ( (f=fopen(argv[1], "r")) == NULL) {
      printf("could not open file %s\n", argv[1]);
      exit(0);
   }

   start = cputime();

   memset(buf, 0, 4096);
   p = fgets(buf, 4096, f);
   p[strlen(p)-1] = '\0';  /* get rid of trailing \n */
   NFA = re_to_nfa(buf, strlen(buf), line++, sid++);
   DFA = NFA->make_dfa();
   //nfa_minimize(DFA);
   tmp_dfa = DFA;
   i++;

   memset(buf, 0, 4096);
   p = fgets(buf, 4096, f);
   while (p != NULL) {
      p[strlen(p)-1] = '\0';  /* get rid of trailing \n */
      NFA = re_to_nfa(buf, strlen(buf), line++, sid++);
      DFA = NFA->make_dfa();
      //nfa_minimize(DFA);
      com_dfa = combine(tmp_dfa, DFA);
      delete tmp_dfa;
      tmp_dfa = com_dfa;
      delete NFA;
      i++;
      memset(buf, 0, 4096);
      p = fgets(buf, 4096, f);
   }
   fclose(f);
  
   //nfa_minimize(com_dfa);
   com_dfa->bdd_output(argv[2], 42);

  end = cputime();
  cout << "Combinition time is " << ((double)(end - start)/1000) << " s" << endl; 

  return 0;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}
