/*-----------------------------------------------------------------------------
 * file:    escape_sequences.h
 * author:  Randy Smith
 * date:    13 July 2006
 * descr:   routines for manipulating and resolving escape sequences
 *
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 * History:
 *-----------------------------------------------------------------------------
 * $Log: escape_sequences.h,v $
 * Revision 1.1  2009/06/09 18:51:21  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:52  smithr
 * initial check in to CVS
 *
 * Revision 1.2  2006/08/10 18:35:34  smithr
 * Several additions and bug fixes, including:
 * (1) user defined char classes implemented.
 * (2) escape sequences fully handled
 * (3) memory management addressed (destructors free mem as necessary)
 * (4) many other miscellaneous bugs, etc.
 *
 * Revision 1.1  2006/08/10 14:23:00  smithr
 * Initial check-in to CVS
 *
 * Revision 1.1  2006/07/15 04:54:02  smithr
 * Extended the grammar to accept negated symbols lists and concatenated
 * lists of symbols, e.g. "ACE" can be used as an alternative to 'A','C','E'
 *
 * Revision 1.2  2006/07/14 20:08:54  smithr
 * CC classes implemented
 *
 * Revision 1.1  2006/07/13 17:13:17  smithr
 * Initial check-in to CVS.  Code is function for KL and KKL patterns
 * in FTP rules.
 *
 *
 *---------------------------------------------------------------------------*/

#ifndef ESCAPE_SEQUENCES_H
#define ESCAPE_SEQUENCES_H

char *convert_escape_sequences(char *string, int *len=NULL);
int parse_char_constant(const char *s, int *actual_read);
int hex_digit(char in);
int octal_digit(char in);
char * output_char(char *str, unsigned int n, unsigned int c,
		   bool inside_char_class = false);


#endif
