/*--------------------------------------------------------------
 * mdfa_simulation.cc
 * Construct multiple DFA's and perform simulation 
 *
 * Author: Rezwana Karim
 * Date:   Oct 14, 2009
 *
 * Load the individual DFA 's from disk and start simulation for a trace file
 * Commented the nfa_minimize() operation due to the fact that it
 * may generate multiple accept ids during the minimization.
 * -------------------------------------------------------------
 *  History:
 *  $Log: mdfa_dfa_simulation.cc,v $
 *  Revision 1.2  2010/09/27 14:48:31  lyangru
 *  final synchronization
 *
 *  Revision 1.1  2009/08/20 15:13:03  lyangru
 *  *** empty log message ***
 *
 * 
 * ------------------------------------------------------------*/
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "re.h"
#include "nfa.h"
#include "minimize.h"
#include "globals.h"
#include <list>
#include <sys/time.h>
#include <sys/resource.h>

#include <unistd.h>
#include <pcap.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <errno.h>

#include "clock.h"
#include "packet.h"
#include "decode.h"

#define MAX_STRING_LEN	256
#define NUM_OF_TEST_ROUND	1

#define DEBUG
using namespace std;

/* this is defined in combine_alg.cc */
nfa_t* combine(nfa_t* NFA1, nfa_t* NFA2);

typedef struct raw_packet
{
      int                allocated; // >0 iff pkt points to allocated data
      unsigned char      *pkbuf;
      packet             pkt;
      unsigned long      id;
      struct pcap_pkthdr hdr;
} raw_packet_t;


string trace_file;

pcap_t *pcap_handle;

/*-----------------------------------------------
 * Function Prototypes
 *----------------------------------------------*/

void init_pcap(pcap_t **handle, string& fname);
int get_next_packet(pcap_t *handle, raw_packet_t* pkt);
size_t dfa_tab_overhead(nfa_t *nfa);


int cputime();
void getFileName(unsigned int dfa_num, char *fileName);

int main (int argc, char *argv[]) {

  FILE *f = NULL;
 // char buf[4096];
  char *dfa_fileName;
  //char *p;
  //int line = 1;
  unsigned int i,j;
 // nfa_t *NFA;
  //nfa_t *DFA;
 // nfa_t *com_dfa, *tmp_dfa;
  int INPUT_ALPHABET_SIZE = 256;
  vector<dfa_tab_t> MDFA;
  
  unsigned int num_dfa_in_mdfa = 0;	/* lower bound of number of states per combined DFA */

  int start, end;
  size_t total_str_len = 0;

  int  dfa_count;
  unsigned long long starttm = 0;
  unsigned long long stoptm = 0;
  unsigned long long total_cycles = 0;
  size_t total_bytes = 0;
  size_t mem_consump = 0;

  
   if (argc != 4) {
     printf("Usage: %s <path to dfa file name> <number of DFA> <trace file name>\n", argv[0]);
     exit(0);
   }

      
   num_dfa_in_mdfa = atoi(argv[2]);

   //dfa_fileName=new char[50];
   //strcpy(dfa_fileName, argv[1]);


   for (dfa_count=1; dfa_count<= num_dfa_in_mdfa; dfa_count++){
      
       dfa_fileName=new char[300];
       strcpy(dfa_fileName, argv[1]);
   
       getFileName(dfa_count, dfa_fileName); 
#ifdef DEBUG
   cout<<"dfa_count="<<dfa_count<<" file "<<dfa_fileName<<endl;
#endif
       
       // cout<<"there"<<endl;
       dfa_tab_t dta;
       dta.populate_dfa_from_file(dfa_fileName, dfa_count);
       //compute memory
       mem_consump += dta.num_states * 256 * sizeof (unsigned int);
        // construct MDFA
       MDFA.push_back(dta);
       if(dfa_fileName!=NULL)
            delete dfa_fileName;         
    }

 
 #ifdef DEBUG   
   cout << "finish building MDFA, num of DFAs is " << MDFA.size() << endl;
 #endif  
   assert(MDFA.size()==num_dfa_in_mdfa); 
 
   /* match test */
   trace_file = argv[3];
   init_pcap(&pcap_handle, trace_file);
   //cout<<"starting simulation"<<endl;
   start = cputime();
   raw_packet_t rp;
   while (get_next_packet(pcap_handle, &rp)) {
     rdtsc(starttm);
     for (i = 0; i < MDFA.size(); i++) {
#ifdef DEBUG_SIMUL
      cout<<"simulating dfa "<<i <<endl;  
#endif      
      MDFA[i].simulate(rp.pkbuf, rp.hdr.caplen, true);   
     }
     rdtsc(stoptm);
     total_bytes += rp.hdr.caplen;
     total_cycles += (stoptm - starttm);
     if (rp.allocated) {
      free(rp.pkbuf);
      rp.allocated = 0;
     }
   }

   end = cputime();

   cout << "MDFA simulation: execution time is " << (double)total_cycles/(double)total_bytes << " cycles/byte" << endl;
   cout << "Memory consumption of MDFA is " << mem_consump << " bytes" << endl;

   return 0;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}

/*--------------------------------
 * init_pcap
 * -------------------------------*/
void init_pcap(pcap_t **handle, string& fname)
{
   char errbuf[PCAP_ERRBUF_SIZE];

   *handle = pcap_open_offline(fname.c_str(), errbuf);
   if (handle == NULL)
   {
      fprintf(stderr, "pcap_open failed: %s\n", errbuf);
      exit(0);
   }
   fprintf(stdout, "Opened trace file %s\n", fname.c_str());
}

/*--------------------------------------
 * get_next_packet
 *-------------------------------------*/
int get_next_packet(pcap_t *handle, raw_packet_t* pkt)
{
   static int id=0;
   const u_int8_t *data;

   data = pcap_next(handle, &(pkt->hdr));
   if (!data)
      return 0;

   pkt->pkbuf = (u_int8_t *)calloc(1, pkt->hdr.caplen);
   memcpy(pkt->pkbuf, data, pkt->hdr.caplen);
   pkt->allocated = 1;
   return 1;
}

/*-------------------------------------
 * dfa_tab_overhead: calculates the space overhead of nfa 
 * after being converted to a dfa_tab_t object
 *------------------------------------*/
size_t dfa_tab_overhead(nfa_t *nfa) {
  size_t sz = 0;
  unsigned int num_acc_ids = 0;
  /* space consumed by transition table */
  sz += nfa->states.size() * sizeof(unsigned int) * MAX_SYMS;
  /* space consumed by accepting ids (also counting the space consumed by null pointers) */
  for (unsigned int i = 0; i < nfa->states.size(); i++) {
    num_acc_ids += nfa->states[i].accept_id.size();
  }
  sz += num_acc_ids * sizeof(int) + nfa->states.size() * sizeof(int);
  return sz;
}

void getFileName(unsigned int dfa_num, char *fileName){
   
   
   strcat(fileName,"/mdfa-dfa-");   
   int i=4;
   char f[6];
   for(;i>=0;i--){
    f[i]=dfa_num%10+'0';
    dfa_num/=10;
   }
   f[5]='\0';
   strcat(fileName,f);
   strcat(fileName,".txt");
   
  
}

